import { auditLinkedTable } from "../constants/constants.js";
import db, { buildSelectQuery } from "../db-config.js";
import { uploadToDDRM } from "../helper/ddrmUploader.js";
import {
  countQueryCondition,
  createQueryBuilder,
  decodeAndParseFields,
  deleteRecord,
  encodeAndStringifyFields,
  getOrganizationAccordingToDepartment,
  getRecord,
  getScheduleById,
  getSchedulingRecordArray,
  getTemplateName,
  insertActivityLog,
  makeJoins,
  processesSingleDDRMDocument,
  searchConditionRecord,
  sendDynamicEmail,
  uniqueIdGenerator,
  updateQueryBuilder,
  uploadFile,
  whereCondition,
} from "../helper/general.js";
import sendEmail from "../helper/sendEmail.js";

import { sendResponse } from "../helper/wrapper.js";
import AuditScheduling from "../sequelize/AuditSchedulingSchema.js";

// export const createUpdateAuditScheduling = async (req, res) => {
//   let { id, department, schedule, evaluation_tool_status, sidebar_id } = req.body;

//   req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
//   let status = id ? "Updated" : "Created";

//   if (department) {
//     req.body.organization = (
//       await getOrganizationAccordingToDepartment(department)
//     )[0]?.organization;
//   }

//   schedule = Array.isArray(schedule) ? JSON.parse(schedule[0]) : JSON.parse(schedule);

//   for (let i = 0; i <= schedule.length; i++) {
//     if ((req.files && req.files[`schedule[${i}][report]`]) || req.body[`schedule[${i}][report]`]) {
//       const file = req.files && req.files[`schedule[${i}][report]`];
//       if (typeof file != "string" && typeof file == "object" && file !== null) {
//         // const filePath = await uploadFile("vehicle_incident_form", file);
//         const ddrm_id = await uploadToDDRM(sidebar_id, file, req);
//         console.log('ddrm_id: ', ddrm_id);
//         // req.body[`schedule`][i]["file"] = filePath;
//         req.body[`schedule`][i]["report"] = ddrm_id;
//       }
//     }
//     // console.log("schedule: ", schedule);
//   }
//   console.log('req.body: ', req.body);

//   // console.log('schedule: ', JSON.parse(schedule));

//   for (let sch of schedule) {
//     const cycle = sch.cycles || 1;
//     const when = sch.repeat_when;
//     // sch = await encodeAndStringifyFields(sch);
//     sch.id = id;
//     sch.organization = req.body.organization;
//     sch.department = req.body.department;
//     sch.schedule_type = req.body.schedule_type;
//     sch.ddrm_id = req.body.ddrm_id;

//     // Initial dates for first record in the cycle
//     let planned_start_date = new Date(sch.planned_start_date);

//     let planned_end_date = new Date(sch.planned_end_date);

//     // console.log(cycle, "cycle");
//     for (let i = 0; i < cycle; i++) {
//       // Set dates for this cycle's audit entry
//       sch.planned_start_date = planned_start_date.toISOString().split("T")[0];
//       sch.planned_end_date = planned_end_date.toISOString().split("T")[0];

//       const { query, values } = id
//       ? updateQueryBuilder(AuditScheduling, sch)
//       : createQueryBuilder(AuditScheduling, sch);

//       const [result] = await db.query(query, values);
//       await insertActivityLog(
//         req.user.sessionid,
//         status,
//         "Audit Scheduling",
//         id ? id : result.insertId
//       );

//       // Calculate the next cycle's dates based on `when` frequency
//       switch (when) {
//         case "Daily":
//           planned_start_date.setDate(planned_start_date.getDate() + 1);
//           planned_end_date.setDate(planned_end_date.getDate() + 1);
//           break;
//         case "Weekly":
//           planned_start_date.setDate(planned_start_date.getDate() + 7);
//           planned_end_date.setDate(planned_end_date.getDate() + 7);
//           break;
//         case "Monthly":
//           planned_start_date.setMonth(planned_start_date.getMonth() + 1);
//           planned_end_date.setMonth(planned_end_date.getMonth() + 1);
//           break;
//         case "Quarterly":
//           planned_start_date.setMonth(planned_start_date.getMonth() + 3);
//           planned_end_date.setMonth(planned_end_date.getMonth() + 3);
//           break;
//         case "Bi-Annually":
//           planned_start_date.setMonth(planned_start_date.getMonth() + 6);
//           planned_end_date.setMonth(planned_end_date.getMonth() + 6);
//           break;
//         case "Annually":
//           planned_start_date.setFullYear(planned_start_date.getFullYear() + 1);
//           planned_end_date.setFullYear(planned_end_date.getFullYear() + 1);
//           break;
//         default:
//           break;
//       }
//     }
//   }

//   return sendResponse(res, 200, `Record ${status} Successfully`);
// };

async function sendScheduledEmail(id) {
  const [scheduledData] = await getScheduleById(id);
  const templateName = getTemplateName(scheduledData.schedule_type);
  const recordData = getSchedulingRecordArray({
    schedulingData: scheduledData,
    templateName,
  });
  let usersToSend = [
    ...scheduledData.lead_person,
    ...scheduledData.participant_details,
  ];
  usersToSend.push({
    name: scheduledData.owner_name,
    email: scheduledData.owner_email,
  });
  if (templateName === "Audit Scheduling") {
    usersToSend = [...usersToSend, ...scheduledData.member_details];
  }
  // if(templateName === "Certification Scheduling"){
  //   // stakeholder
  // }

  let subject = `Successful Scheduling of ${scheduledData.schedule_type} - ${scheduledData.name}`;

  // return console.log('usersToSend: ', usersToSend);
  // recordData.name = "MOHD"
  // await sendDynamicEmail({
  //   to: "mohammad.tariq.sartia@gmail.com",
  //   subject,
  //   data: recordData,
  // });
  for (let user of usersToSend) {
    recordData.name = user.name;
    await sendDynamicEmail({
      to: user.email,
      subject,
      data: recordData,
    });
  }
}
export const createUpdateAuditScheduling = async (req, res) => {
  let {
    id,
    department,
    schedule,
    evaluation_tool_status,
    sidebar_id = 274,
  } = req.body;
  schedule = JSON.parse(schedule);
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  let status = id ? "Updated" : "Created";

  if (department) {
    req.body.organization = (
      await getOrganizationAccordingToDepartment(department)
    )[0]?.organization;
  }

  for (let i = 0; i < schedule.length; i++) {
    const sch = schedule[i];
    sch.lead_person = req.body[`schedule[${i}][lead_person]`];
    const cycle = sch.cycles || 1;
    const when = sch.repeat_when;
    // sch = await encodeAndStringifyFields(sch);
    if (sch.evaluation_tool_status === "Not Applicable") {
      if (req.body[`schedule[${i}][report]`]) {
        sch.report = req.body[`schedule[${i}][report]`];
        delete sch?.ddrm_id;
      }
      if (req.files && req.files[`schedule[${i}][report]`]) {
        const ddrm_id = await processesSingleDDRMDocument(
          "audit_scheduling",
          sidebar_id,
          req.files[`schedule[${i}][report]`],
          req
        );
        sch.ddrm_id = ddrm_id;
        sch.status = "Executed";
      }
    }

    sch.id = id;
    sch.organization = req.body.organization;
    sch.department = req.body.department;
    sch.schedule_type = req.body.schedule_type;

    const file = req.files && req.files[`schedule[${i}][report]`];
    if (file) {
      const ddrm_id = await processesSingleDDRMDocument(
        "audit_scheduling",
        sidebar_id,
        file,
        req
      );
      sch.ddrm_id = ddrm_id;
    }
    // Initial dates for first record in the cycle
    let planned_start_date = new Date(sch.planned_start_date);
    let planned_end_date = new Date(sch.planned_end_date);

    const stakeholderType = sch.participant_type;
    const stakeholder = sch.stakeholder;
    // ! Stakeholders Involved - email notification to be sent to the selected stakeholders
    // for internal
    if (stakeholderType && stakeholderType === "Internal") {
      const participants = sch.participants;
      const planned_start_date = sch.planned_start_date;
      const planned_end_date = sch.planned_end_date;
      const auditName = sch.name;
      for (let j = 0; j < participants.length; j++) {
        const [employeeRecord] = await getRecord(
          "users",
          "id",
          participants[j]
        );
        const email = employeeRecord?.email;
        console.log(
          "email: ",
          email,
          auditName,
          planned_start_date,
          planned_end_date
        );
        if (email) {
          const name = employeeRecord?.name + " " + employeeRecord?.surname;
          const sendRecordArray = {
            templateFileUrl: "mail_for_audit_scheduling_template.html", // template had to change
            name: name,
            planned_start_date: planned_start_date,
            planned_end_date: planned_end_date,
            audit_name: auditName,
            templateName: "Audit Scheduling",
          };

          // const info = await sendEmail(
          //   "info@harmonyandhelp.com",
          //   email,
          //   `Audit ${id ? "Updated" : "Scheduled"} `,
          //   sendRecordArray
          // );
        }
      }
    } else if (stakeholderType && stakeholderType === "External") {
      const participants = sch.participants;
      const planned_start_date = sch.planned_start_date;
      const planned_end_date = sch.planned_end_date;
      const auditName = sch.name;
      console.log("stakeholder: ", stakeholder);
      for (let j = 0; j < stakeholder.length; j++) {
        const item = stakeholder[j];
        const sendRecordArray = {
          templateFileUrl: "mail_for_audit_scheduling_template.html", // template had to change
          name: item.name,
          planned_start_date: planned_start_date,
          planned_end_date: planned_end_date,
          audit_name: auditName,
          templateName: "Audit Scheduling",
        };
        // const info = await sendEmail(
        //   "info@harmonyandhelp.com",
        //   item.stakeholder_email,
        //   `Audit ${id ? "Updated" : "Scheduled"} `,
        //   sendRecordArray
        // );
      }
      // for (let j = 0; j < participants.length; j++) {
      //   const [employeeRecord] = await getRecord(
      //     "users",
      //     "id",
      //     participants[j]
      //   );
      //   const email = employeeRecord?.email;
      //   if (email) {
      //     const name = employeeRecord?.name + " " + employeeRecord?.surname;
      //     const sendRecordArray = {
      //       templateFileUrl: "mail_for_audit_scheduling_template.html", // template had to change
      //       name: name,
      //       planned_start_date: planned_start_date,
      //       planned_end_date: planned_end_date,
      //       audit_name: auditName,
      //     };

      //     const info = await sendEmail(
      //       "info@harmonyandhelp.com",
      //       email,
      //       `Audit ${id ? "Updated" : "Scheduled"} `,
      //       sendRecordArray
      //     );
      //   }
      // }
    }
    const initials = sch?.schedule_type?.toUpperCase()?.slice(0, 3) || "Aud";
    // console.log(cycle, "cycle");
    for (let i = 0; i < cycle; i++) {
      // Set dates for this cycle's audit entry
      sch.planned_start_date = planned_start_date.toISOString().split("T")[0];
      sch.planned_end_date = planned_end_date.toISOString().split("T")[0];
      if (!id) {
        const unique_id = await uniqueIdGenerator(
          req.body.organization,
          department,
          initials,
          "audit_scheduling",
          "unique_id",
          "unique_id"
        );
        sch.unique_id = unique_id;
      }

      // console.log("sch: ", sch);
      const { query, values } = id
        ? updateQueryBuilder(AuditScheduling, sch)
        : createQueryBuilder(AuditScheduling, sch);

      const [result] = await db.query(query, values);

      if (!id) {
        console.log("result.insertId: ", result.insertId);
        await sendScheduledEmail(result.insertId);
      }

      await insertActivityLog(
        req.user.sessionid,
        status,
        "Audit Scheduling",
        id ? id : result.insertId
      );

      // Calculate the next cycle's dates based on `when` frequency
      switch (when) {
        case "Daily":
          planned_start_date.setDate(planned_start_date.getDate() + 1);
          planned_end_date.setDate(planned_end_date.getDate() + 1);
          break;
        case "Weekly":
          planned_start_date.setDate(planned_start_date.getDate() + 7);
          planned_end_date.setDate(planned_end_date.getDate() + 7);
          break;
        case "Monthly":
          planned_start_date.setMonth(planned_start_date.getMonth() + 1);
          planned_end_date.setMonth(planned_end_date.getMonth() + 1);
          break;
        case "Quarterly":
          planned_start_date.setMonth(planned_start_date.getMonth() + 3);
          planned_end_date.setMonth(planned_end_date.getMonth() + 3);
          break;
        case "Bi-Annually":
          planned_start_date.setMonth(planned_start_date.getMonth() + 6);
          planned_end_date.setMonth(planned_end_date.getMonth() + 6);
          break;
        case "Annually":
          planned_start_date.setFullYear(planned_start_date.getFullYear() + 1);
          planned_end_date.setFullYear(planned_end_date.getFullYear() + 1);
          break;
        default:
          break;
      }
    }
  }

  return sendResponse(res, 200, `Record ${status} Successfully`);
};

/**Function to view all Audit Scheduling */
export const viewAllAuditScheduling = async (req, res) => {
  const { id } = req.params;
  const condition = await whereCondition({
    table: "audit_scheduling",
    page: req.query.page,
    all: req.query.all,
    pageSize: req.query.pageSize,
    filter: req.query.filter,
    id,
    user: req.user,
  });

  const searchTableName = [
    "audit_scheduling.name",
    "audit_scheduling.linked_to",
    // "audit_scheduling.when",
    "audit_scheduling.cycles",
    "audit_scheduling.members",
    "audit_scheduling.owner",
    "audit_scheduling.participants",
    "audit_scheduling.scope",
    "audit_scheduling.critical_business",
    "audit_scheduling.financial_resource",
    "audit_scheduling.evaluation_tool",
  ];
  /** If value come with any search condition then search that word */
  let searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );

  /**Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "audit_type",
      onCondition: "audit_type.id = audit_scheduling.type",
    },
    {
      type: "left",
      targetTable: "sidebar AS Module",
      onCondition: "Module.id = audit_scheduling.module",
    },
    {
      type: "left",
      targetTable: "sidebar AS subModule",
      onCondition: "subModule.id = audit_scheduling.sub_module",
    },
    {
      type: "left",
      targetTable: "users",
      onCondition: "users.id = audit_scheduling.created_by",
    },
    {
      type: "left",
      targetTable: "users as owner",
      onCondition: "owner.id = audit_scheduling.owner",
    },
    {
      type: "left",
      targetTable: "organization",
      onCondition: "organization.id = audit_scheduling.organization",
    },
    {
      type: "left",
      targetTable: "audit_scheduling AS reference",
      onCondition: "reference.id = audit_scheduling.reference_number",
    },
    {
      type: "left",
      targetTable: "location",
      onCondition: "location.id = audit_scheduling.location",
    },
    {
      type: "left",
      targetTable: "currency as operating_budget_currency",
      onCondition:
        "operating_budget_currency.id = audit_scheduling.operating_budget_currency",
    },
    {
      type: "left",
      targetTable: "currency as capital_budget_currency",
      onCondition:
        "capital_budget_currency.id = audit_scheduling.capital_budget_currency",
    },
    {
      type: "left",
      targetTable: "repository",
      onCondition: "repository.id = audit_scheduling.ddrm_id",
    },
  ];
  const joinsRecord = await makeJoins(joins);

  /**Record of all alert */
  const auditSchedulingDataFetchQuery = `SELECT audit_scheduling.*, CONCAT(users.name , ' ' , users.surname) AS created_by_name , audit_type.name AS type_name , Module.title AS module_name , subModule.title AS sub_module_name , reference.name AS reference_number_name ,users.profile as created_by_profile, location.name as location_name ,organization.name as  organization_name , operating_budget_currency.name AS operating_budget_currency_name, capital_budget_currency.name AS capital_budget_currency_name, repository.url as report, CONCAT(owner.name , ' ' , owner.surname) AS owner_name FROM audit_scheduling  ${joinsRecord} WHERE audit_scheduling.deleted = 0 ${searchCondition} ${condition}`;

  let [auditSchedulingDataFetch] = await db.query(
    auditSchedulingDataFetchQuery
  );

  auditSchedulingDataFetch = await decodeAndParseFields(
    auditSchedulingDataFetch
  );

  for (let audit of auditSchedulingDataFetch) {
    // for specific record get name
    const linked_to = audit.linked_to;
    const record = audit.record_name;
    if (linked_to && record) {
      const tableName = auditLinkedTable[linked_to];
      const mappedFields = await buildSelectQuery(tableName);
      let query = `SELECT id, ${mappedFields} FROM ${tableName} WHERE deleted = 0 AND id = ${record}`;
      if (tableName === "permit_license_compliance") {
        query = `SELECT permit_license_compliance.id, permit_license.name as name FROM ${tableName} LEFT JOIN permit_license ON permit_license.id = permit_license_compliance.name WHERE permit_license_compliance.deleted = 0  AND permit_license_compliance.id = ${record}`;
      }
      const [result] = await db.query(query);
      audit.record_name_name = result[0]?.name;
    }
    const sizeInBytes =
      audit.report_size != null && parseInt(audit.report_size, 10); // Assuming 'size' column contains size in bytes
    const size = sizeInBytes
      ? sizeInBytes > 1024
        ? `${(sizeInBytes / 1024).toFixed(2)} KB`
        : `${sizeInBytes} Bytes`
      : null;
    audit.report_size = size;

    const participants = audit.participants;

    let partDetails = [];
    if (participants) {
      [partDetails] = await db.query(
        `SELECT CONCAT(name , ' '  , surname ) AS name , profile FROM users WHERE id IN (${participants})`
      );
    }
    audit.participant_details = partDetails;
    let leadPersonDetails = [];
    const source = audit.source;
    if (audit?.lead_person?.length) {
      const lead_persons = audit.lead_person;
      if (source == "Internal") {
        if (Array.isArray(lead_persons) && lead_persons.length > 0) {
          // Filter out null or invalid values
          const validLeadPersons = lead_persons.filter(
            (id) => id !== null && id !== undefined && id !== ""
          );

          if (validLeadPersons.length > 0) {
            // Construct the query
            const leadIds = validLeadPersons.join(",");

            if (leadIds.length) {
              // Fetch data from the database
              [leadPersonDetails] = await db.query(
                `SELECT CONCAT(name, ' ', surname) AS name, profile 
                     FROM users 
                     WHERE id IN (${leadIds})`
              );
            }
          }
        }

        // [leadPersonDetails] = await db.query(
        //   `SELECT CONCAT(name , ' '  , surname ) AS name , profile FROM users WHERE id IN (${lead_persons})`
        // );
        if (audit.schedule_type === "certifications") {
          audit.lead_person = leadPersonDetails;
        } else {
          audit.lead_person = audit.lead_person[0];
          audit.lead_person_name = leadPersonDetails[0]?.name;
          audit.lead_person_profile = leadPersonDetails[0]?.profile;
        }
      } else {
        const lead_persons = audit.lead_person;
        [leadPersonDetails] = await db.query(
          `SELECT * FROM contractor_registration WHERE id IN (${lead_persons})`
        );
        for (let leadPerson of leadPersonDetails) {
          leadPerson.lead_person_name = leadPerson.contractor_name;
        }
        audit.lead_person = leadPersonDetails;
      }
    }
    const members = audit.members;
    if (Array.isArray(members) && members.length > 0) {
      if (source == "Internal") {
        const [membersList] = await db.query(
          `SELECT CONCAT(users.name , ' ' , users.surname) AS name , users.profile AS profile FROM users WHERE users.id IN (${members}) `
        );
        audit.member_details = membersList;
      } else {
        const [membersList] = await db.query(
          `SELECT contractor_name FROM contractor_registration WHERE id IN (${members}) `
        );
        audit.member_details = membersList;
      }
    }
    const criticalBusiness = audit.critical_business;
    if (Array.isArray(criticalBusiness) && criticalBusiness.length > 0) {
      const [criticalBusinessList] = await db.query(
        `SELECT id,name FROM business_processes WHERE id IN (${criticalBusiness})`
      );
      audit.critical_business_details = criticalBusinessList;
    }
    const submoduleId = audit.sub_module;
    if (submoduleId) {
      const recordId = audit.record_name;

      const [submoduleData] = await db.query(
        `SELECT * FROM sidebar WHERE id = ${submoduleId}`
      );

      const subModule = submoduleData[0];
      const tableName = subModule.table_name;

      const [recordDetails] = await db.query(
        `SELECT * FROM ${tableName} WHERE id = ${recordId}`
      );

      if (recordDetails.length) {
        audit.record = recordDetails[0]?.name;
      }
    }
  }
  /**Count all Audit Scheduling */
  const totalRecord = await countQueryCondition(auditSchedulingDataFetchQuery);

  return sendResponse(res, 200, auditSchedulingDataFetch, totalRecord);
};

/**Function to delete a specific Audit Scheduling */
export const deleteAuditScheduling = async (req, res) => {
  const { id } = req.params;
  const deleteRecordQuery = await deleteRecord(AuditScheduling, id);
  if (deleteRecordQuery) {
    /**Insert record for activity log */
    insertActivityLog(req.user.sessionid, "delete", "Audit Scheduling", id);
    return sendResponse(res, 200, "Record deleted successfully");
  }
};

export const uploadReport = async (req, res) => {
  const {
    sidebar_id = 155,
    id,
    actual_start_date,
    actual_end_date,
    ddrm_id,
  } = req.body;
  // const report = req.files.report;
  if (!ddrm_id) {
    return sendResponse(res, 400, "Attachment is required");
  }
  // const ddrm_id = await uploadToDDRM(sidebar_id, report, req);
  const { query, values } = updateQueryBuilder(AuditScheduling, {
    id,
    ddrm_id,
    actual_start_date,
    actual_end_date,
    status: "Executed",
  });
  const [result] = await db.query(query, values);
  if (result.affectedRows > 0) {
    return sendResponse(res, 200, "report uploaded successfully");
  } else {
    return sendResponse(res, 400, "Error uploading report");
  }
};

export const addEvaluationTool = async (req, res) => {
  const { id, evaluation_tool_status, evaluation_tool } = req.body;
  if (!evaluation_tool) {
    return sendResponse(res, 400, "evaluation tool is required");
  }
  const { query, values } = updateQueryBuilder(AuditScheduling, {
    id,
    ...req.body,
  });
  const [result] = await db.query(query, values);
  if (result.affectedRows > 0) {
    return sendResponse(res, 200, "Tool added successfully");
  } else {
    return sendResponse(res, 400, "Error adding tool");
  }
};

export const getSpecificRecords = async (req, res, next) => {
  const { id } = req.params;
  const { name } = req.query;
  let tables = {
    Permits: "permit_license_compliance",
    SOPs: "sops",
    Policy: "policy",
    Action: "custom_action_creation",
    Incident: "incident",
    NCR: "ncr_recording",
    "Business Continuity": "bcp_management",
  };

  const tableName = tables[name];
  if (!tableName) {
    return sendResponse(res, 400, name + " not found");
  }

  const condition = await whereCondition({
    table: tableName,
    page: req.query.page,
    all: req.query.all,
    pageSize: req.query.pageSize,
    filter: req.query.filter,
    id,
    user: req.user,
  });
  const mappedFields = await buildSelectQuery(tableName);

  let query = `SELECT id, ${mappedFields} FROM ${tableName} WHERE deleted = 0 ${condition}`;
  if (tableName === "permit_license_compliance") {
    query = `SELECT permit_license_compliance.id, permit_license.name as name FROM ${tableName} LEFT JOIN permit_license ON permit_license.id = permit_license_compliance.name WHERE permit_license_compliance.deleted = 0 ${condition}`;
  }
  const [result] = await db.query(query);
  const totalRecord = await countQueryCondition(query);

  return sendResponse(res, 200, result, totalRecord);
};
