import db from "../db-config.js";
import { sendResponse } from "../helper/wrapper.js";
import {
  insertActivityLog,
  searchConditionRecord,
  makeJoins,
  whereCondition,
  countQueryCondition,
  settingsUpdater,
  deleteSettingRecord,
  encodeSingle_statement,
  decodeSingle_statement,
  uniqueIdGenerator,
  getFirstCreatedAndAllOrganizationIds,
  encodeAndStringifyFields,
  updateQueryBuilder,
  createQueryBuilder,
  getFilterConditions,
  getListingData,
} from "../helper/general.js";
import AuditType from "../sequelize/AuditTypeSchema.js";

/** Function to create or update AuditType */
export const createUpdateAuditType = async (req, res) => {
  const { id, organization } = req.body;

  if (id && organization.length === 0) {
    return sendResponse(res, 404, "Please Select at least one business Structure");
  }

  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();

    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "ADT",
      "audit_type",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization = organization.length > 0 ? organization : result.organizationIds;
  }

  let status = id ? "Updated" : "Created";
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  req.body = await encodeAndStringifyFields(req.body);
  const { query, values } = id ? updateQueryBuilder(AuditType, req.body) : createQueryBuilder(AuditType, req.body);
  const [result] = await db.query(query, values);
  await insertActivityLog(req.user.sessionid, status, "AuditType", id ? id : result.insertId);
  return sendResponse(res, 200, `Record ${status} Successfully`);
};

/** Function to view all or single AuditType */
export const viewAuditType = async (req, res) => {
  let { organizationCondition, condition } = await getFilterConditions(req, db, "audit_type");

  // const { id } = req.params;
  // const condition = await whereCondition({
  //   table: "audit_type",
  //   page: req.query.page,
  //   all: req.query.all,
  //   pageSize: req.query.pageSize,
  //   filter: req.query.filter,
  //   id,
  //   user: req.user,
  //   grouped: req.query.grouped,
  // });

  const searchFields = ["audit_type.name", "audit_type.description", "users.name"];
  let searchCondition = await searchConditionRecord(req.query.search, searchFields);
  const joins = [
    {
      type: "left",
      targetTable: "users",
      onCondition: "users.id = audit_type.created_by",
    },
    // {
    //   type: "left",
    //   targetTable: "organization",
    //   onCondition: "organization.id = audit_type.organization",
    // },
  ];
  const joinsRecord = await makeJoins(joins);

  const fetchQuery = `SELECT audit_type.*, users.name AS created_by, audit_type.organization AS organizations FROM audit_type ${joinsRecord} WHERE audit_type.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;
  let [records] = await db.query(fetchQuery);

  records = await getListingData(records);

  // for (const record of records) {
  //   record.description = await decodeSingle_statement(record.description);
  //   if (req.query.grouped == "true") {
  //     const [organizations] = await db.query(
  //       `SELECT organization FROM audit_type WHERE deleted = 0 AND name = ?`,
  //       [record.name]
  //     );
  //     const arr = organizations.map((item) => item.organization);
  //     record.organizations = arr;
  //   }
  // }

  const totalRecord = await countQueryCondition(fetchQuery);
  return sendResponse(res, 200, records, totalRecord);
};

/** Function to delete AuditType */
export const deleteAuditType = async (req, res) => {
  const { id } = req.params;
  const deleteRecord = await deleteSettingRecord("audit_type", id);
  if (deleteRecord) {
    await insertActivityLog(req.user.sessionid, "delete", "AuditType", id);
    return sendResponse(res, 200, "Record deleted successfully");
  } else {
    return sendResponse(res, 404, "Record not found");
  }
};
