import db from "../db-config.js";
import { sendResponse } from "../helper/wrapper.js";
import {
  insertActivityLog,
  searchConditionRecord,
  makeJoins,
  whereCondition,
  countQueryCondition,
  settingsUpdater,
  deleteSettingRecord,
  encodeSingle_statement,
  decodeSingle_statement,
  uniqueIdGenerator,
  getFirstCreatedAndAllOrganizationIds,
  encodeAndStringifyFields,
  updateQueryBuilder,
  createQueryBuilder,
  getFilterConditions,
  getListingData,
} from "../helper/general.js";
import BestPractice from "../sequelize/BestPracticeSchema.js";

/** Function to create or update BestPractice */
export const createUpdateBestPractice = async (req, res) => {
  const { id, organization } = req.body;

  if (id && organization.length === 0) {
    return sendResponse(res, 404, "Please Select at least one business Structure");
  }

  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();

    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "BestPractice",
      "best_practice",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization = organization.length > 0 ? organization : result.organizationIds;
  }

  let status = id ? "Updated" : "Created";
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  req.body = await encodeAndStringifyFields(req.body);
  const { query, values } = id
    ? updateQueryBuilder(BestPractice, req.body)
    : createQueryBuilder(BestPractice, req.body);
  const [result] = await db.query(query, values);
  await insertActivityLog(req.user.sessionid, status, "BestPractice", id ? id : result.insertId);
  return sendResponse(res, 200, `Record ${status} Successfully`);
};
// export const createUpdateBestPractice = async (req, res) => {
//   const { id, name, description } = req.body;
//   const encodedDescription = await encodeSingle_statement(description);

//   if (id) {
//     const result = await settingsUpdater(
//       BestPractice,
//       req.body.organization,
//       req.body,
//       req.user
//     );
//     if (!result) {
//       return sendResponse(res, 404, "No data found");
//     }
//     await insertActivityLog(req.user.sessionid, "update", "BestPractice", `This user updated BestPractice with id: ${id}`);
//     return sendResponse(res, 200, "Record updated successfully");
//   } else {
//     const insertPromises = req.body.organization.map(async (org) => {
//       const [checkName] = await db.query(`SELECT name FROM best_practice WHERE name = ? AND deleted = 0 AND organization = ?`, [name, org]);
//       if (checkName.length === 0) {
//          const unique_id = await uniqueIdGenerator(
//             org,
//             req?.body?.department || null,
//             "BestPractice",
//             "best_practice",
//             "unique_id",
//             "unique_id"
//           );

//         await db.query(`INSERT INTO best_practice (name, description, created_by, organization,unique_id) VALUES (?,?, ?, ?, ?)`, [name, encodedDescription, req.user.sessionid, org,unique_id]);
//         await insertActivityLog(req.user.sessionid, "create", "BestPractice", `This user created a new BestPractice '${name}' for organization ${org}`);
//       }
//     });
//     await Promise.all(insertPromises);
//     return sendResponse(res, 200, "Record created successfully");
//   }
// };

/** Function to view all or single BestPractice */
export const viewBestPractice = async (req, res) => {
  let { organizationCondition, condition } = await getFilterConditions(req, db, "best_practice");

  // const { id } = req.params;
  // const condition = await whereCondition({
  //   table: "best_practice",
  //   page: req.query.page,
  //   all: req.query.all,
  //   pageSize: req.query.pageSize,
  //   filter: req.query.filter,
  //   id,
  //   user: req.user,
  //   grouped: req.query.grouped,
  // });

  const searchFields = ["best_practice.name", "best_practice.description", "users.name"];
  let searchCondition = await searchConditionRecord(req.query.search, searchFields);
  const joins = [
    { type: "left", targetTable: "users", onCondition: "users.id = best_practice.created_by" },
    // { type: "left", targetTable: "organization", onCondition: "organization.id = best_practice.organization" }
  ];
  const joinsRecord = await makeJoins(joins);

  const fetchQuery = `SELECT best_practice.*, CONCAT(users.name, ' ', users.surname) AS created_by, best_practice.organization AS organizations FROM best_practice ${joinsRecord} WHERE best_practice.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;
  let [records] = await db.query(fetchQuery);

  records = await getListingData(records);
  // for (const record of records) {
  //   record.description = await decodeSingle_statement(record.description);
  //    if (req.query.grouped == "true") {
  //     const [organizations] = await db.query(
  //       `SELECT organization FROM best_practice WHERE deleted = 0 AND name = ?`,
  //       [record.name]
  //     );
  //     const arr = organizations.map((item) => item.organization);
  //     record.organizations = arr;
  //   }
  // }

  const totalRecord = await countQueryCondition(fetchQuery);
  return sendResponse(res, 200, records, totalRecord);
};

/** Function to delete BestPractice */
export const deleteBestPractice = async (req, res) => {
  const { id } = req.params;
  const deleteRecord = await deleteSettingRecord("best_practice", id);
  if (deleteRecord) {
    await insertActivityLog(req.user.sessionid, "delete", "BestPractice", id);
    return sendResponse(res, 200, "Record deleted successfully");
  } else {
    return sendResponse(res, 404, "Record not found");
  }
};
