import db from "../db-config.js";
import { sendResponse } from "../helper/wrapper.js";
import {
  insertActivityLog,
  searchConditionRecord,
  makeJoins,
  whereCondition,
  countQueryCondition,
  settingsUpdater,
  deleteSettingRecord,
  encodeSingle_statement,
  decodeSingle_statement,
  uniqueIdGenerator,
  getFirstCreatedAndAllOrganizationIds,
  encodeAndStringifyFields,
  updateQueryBuilder,
  createQueryBuilder,
  getFilterConditions,
  getListingData,
  getRecord,
} from "../helper/general.js";
import CommunicationMethod from "../sequelize/CommunicationMethodSchema.js";

/** Function to create or update CommunicationMethod */
export const createUpdateCommunicationMethod = async (req, res) => {
  const { id, name,organization } = req.body;

  if (id && organization.length === 0) {
    return sendResponse(res, 404, "Please Select at least one business Structure");
  }

  const [checkNameWithOrganization] = await getRecord("communication_method", "name", name);
    if (checkNameWithOrganization) {
      if (id && checkNameWithOrganization.id != id) {
        return sendResponse(res, 400, "Communication Method name already exist");
      } else if (!id) {
        return sendResponse(res, 400, "Communication Method name already exist");
      }
    }

  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();

    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "BCPCM",
      "communication_method",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization = organization.length > 0 ? organization : result.organizationIds;
  }

  let status = id ? "Updated" : "Created";
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  req.body = await encodeAndStringifyFields(req.body);
  const { query, values } = id
    ? updateQueryBuilder(CommunicationMethod, req.body)
    : createQueryBuilder(CommunicationMethod, req.body);
  const [result] = await db.query(query, values);
  await insertActivityLog(req.user.sessionid, status, "CommunicationMethod", id ? id : result.insertId);
  return sendResponse(res, 200, `Record ${status} Successfully`);
};
// export const createUpdateCommunicationMethod = async (req, res) => {
//   const { id, name, description, department } = req.body;
//   const encodedDescription = await encodeSingle_statement(description);

//   if (id) {
//     const result = await settingsUpdater(
//       CommunicationMethod,
//       req.body.organization,
//       req.body,
//       req.user
//     );
//     if (!result) {
//       return sendResponse(res, 404, "No data found");
//     }
//     await insertActivityLog(req.user.sessionid, "update", "CommunicationMethod", `This user updated CommunicationMethod with id: ${id}`);
//     return sendResponse(res, 200, "Record updated successfully");
//   } else {
//     if(!id) {
//       const unique_id = await uniqueIdGenerator(
//         req.body.organization,
//         department,
//         "BCPCM",
//         "communication_method",
//         "unique_id",
//         "unique_id"
//       );
//       req.body.unique_id = unique_id;
//     }
//     const insertPromises = req.body.organization.map(async (org) => {
//       const [checkName] = await db.query(`SELECT name FROM communication_method WHERE name = ? AND deleted = 0 AND organization = ?`, [name, org]);
//       if (checkName.length === 0) {
//         await db.query(`
//           INSERT INTO communication_method (name, description, created_by, organization, unique_id) VALUES (?, ?, ?, ?, ?)`,
//           [name, encodedDescription, req.user.sessionid, org, req.body.unique_id]);
//         await insertActivityLog(req.user.sessionid, "create", "CommunicationMethod", `This user created a new CommunicationMethod '${name}' for organization ${org}`);
//       }
//     });
//     await Promise.all(insertPromises);
//     return sendResponse(res, 200, "Record created successfully");
//   }
// };

/** Function to view all or single CommunicationMethod */
export const viewCommunicationMethod = async (req, res) => {
  let { organizationCondition, condition } = await getFilterConditions(req, db, "communication_method");

  // const { id } = req.params;
  // const condition = await whereCondition({
  //   table: "communication_method",
  //   page: req.query.page,
  //   all: req.query.all,
  //   pageSize: req.query.pageSize,
  //   filter: req.query.filter,
  //   id,
  //   user: req.user,
  //   grouped: req.query.grouped,
  // });

  const searchFields = [
    "communication_method.name",
    "communication_method.description",
    "users.name",
  ];
  let searchCondition = await searchConditionRecord(req.query.search, searchFields);
  const joins = [
    { type: "left", targetTable: "users", onCondition: "users.id = communication_method.created_by" },
    // { type: "left", targetTable: "organization", onCondition: "organization.id = communication_method.organization" },
  ];
  const joinsRecord = await makeJoins(joins);

  const fetchQuery = `SELECT communication_method.*, CONCAT(users.name, ' ', users.surname) AS created_by, communication_method.organization AS organizations FROM communication_method ${joinsRecord} WHERE communication_method.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;
  let [records] = await db.query(fetchQuery);

  records = await getListingData(records);

  // for (const record of records) {
  //   record.description = await decodeSingle_statement(record.description);
  //    if (req.query.grouped == "true") {
  //     const [organizations] = await db.query(
  //       `SELECT organization FROM communication_method WHERE deleted = 0 AND name = ?`,
  //       [record.name]
  //     );
  //     const arr = organizations.map((item) => item.organization);
  //     record.organizations = arr;
  //   }
  // }

  const totalRecord = await countQueryCondition(fetchQuery);
  return sendResponse(res, 200, records, totalRecord);
};

/** Function to delete CommunicationMethod */
export const deleteCommunicationMethod = async (req, res) => {
  const { id } = req.params;
  const deleteRecord = await deleteSettingRecord("communication_method", id);
  if (deleteRecord) {
    await insertActivityLog(req.user.sessionid, "delete", "CommunicationMethod", id);
    return sendResponse(res, 200, "Record deleted successfully");
  } else {
    return sendResponse(res, 404, "Record not found");
  }
};
