// import { schedule } from "node-cron";
// import db from "../db-config.js";
// import {
//   countQueryCondition,
//   createQueryBuilder,
//   decodeAndParseFields,
//   decodeSingle_statement,
//   deleteRecord,
//   encodeSingle_statement,
//   getOrganizationAccordingToDepartment,
//   insertActivityLog,
//   makeJoins,
//   searchConditionRecord,
//   updateQueryBuilder,
//   whereCondition,
// } from "../helper/general.js";

// import { sendResponse } from "../helper/wrapper.js";
// import ContractorAuditProtocol from "../sequelize/ContractorAuditProtocolSchema.js";
// import ContractorAuditScheduling from "../sequelize/ContractorAuditSchedulingSchema.js";

// /**Function to create and update Contractor Audit Scheduling  */
// export const createUpdateContractorAuditScheduling = async (req, res) => {
//   let {
//     id,
//     audit_name,
//     critical_business_processes,
//     organization,
//     department,
//   } = req.body;

//   /**Check record if organization is not coming then fetch organization according to department */
//   let organizationId = organization;
//   if (department) {
//     const recordAccordingToOrganization =
//       await getOrganizationAccordingToDepartment(department);
//     organizationId = recordAccordingToOrganization[0].organization;
//     req.body.organization = organizationId;
//   }
//   req.body.critical_business_processes = await encodeSingle_statement(
//     critical_business_processes
//   );
//   /**If id comes in body then it will update the query */
//   if (id) {
//     req.body.updated_by = req.user.sessionid;
//     /**Check that this organization have that particular audit_name or not*/
//     const [checkNameWithOrganization] = await db.query(
//       "SELECT audit_name FROM contractor_audit_scheduling WHERE audit_name = ? AND deleted = '0' AND id != ? AND organization = ?",
//       [audit_name, id, organization]
//     );
//     if (checkNameWithOrganization.length > 0) {
//       return sendResponse(
//         res,
//         400,
//         `Record with Audit Name ${audit_name} already exists.`
//       );
//     }
//     const { query, values } = updateQueryBuilder(
//       ContractorAuditScheduling,
//       req.body
//     );
//     await db.query(query, values);
//     /**Insert record for activity log */
//     insertActivityLog(
//       req.user.sessionid,
//       "update",
//       "Contractor Audit Scheduling",
//       `This user Update Contractor Audit Scheduling which id is ${id}`
//     );
//     if (id) {
//       const { query, values } = updateQueryBuilder(
//         ContractorAuditProtocol,
//         {
//           scheduled_audit: id,
//           contractor: req.body.contractor,
//           created_by: req.user.sessionid,
//           organization: req.body.organization,
//           department: req.body.department,
//           status: "Pending",
//         },
//         { scheduled_audit: id }
//       );
//       console.log(query, values);
//       await db.query(query, values);
//     }

//     return sendResponse(res, 200, "Record updated successfully");
//   } else {
//     /** Check if this organization already has the particular audit_name */
//     const [checkNameWithOrganization] = await db.query(
//       `SELECT audit_name FROM contractor_audit_scheduling WHERE audit_name = ? AND deleted = '0' AND organization = ?`,
//       [audit_name, organizationId]
//     );
//     if (checkNameWithOrganization.length > 0) {
//       return sendResponse(
//         res,
//         400,
//         `Record with Audit Name ${audit_name} already exists.`
//       );
//     }
//     req.body.created_by = req.user.sessionid;
//     req.body.status = req.body.status ?? "Scheduled";
//     /** Insert Contractor Audit Scheduling details */
//     const { query, values } = createQueryBuilder(
//       ContractorAuditScheduling,
//       req.body
//     );
//     console.log(query, values);
//     const [result] = await db.query(query, values);

//     if (!id) {
//       const { query, values } = createQueryBuilder(ContractorAuditProtocol, {
//         scheduled_audit: result.insertId,
//         contractor: req.body.contractor,
//         created_by: req.user.sessionid,
//         organization: req.body.organization,
//         department: req.body.department,
//         project: req.body.project,
//         status: "Pending",
//       });
//       console.log(query, values);
//       await db.query(query, values);
//     }

//     /** Insert record for activity log */
//     await insertActivityLog(
//       req.user.sessionid,
//       "create",
//       "Contractor Audit Scheduling",
//       `This user created a new Contractor Audit Scheduling named ${audit_name} for organization ${organizationId}`
//     );

//     return sendResponse(res, 200, "Record created successfully");
//   }
// };

// /**Function to view all Contractor Audit Scheduling */
// export const viewAllContractorAuditScheduling = async (req, res) => {
//   const { id } = req.params;
//   const condition = await whereCondition({
//     table: "contractor_audit_scheduling",
//     page: req.query.page,
//     all: req.query.all,
//     pageSize: req.query.pageSize,
//     filter: req.query.filter,
//     id,
//     user: req.user,
//   });

//   const searchTableName = [
//     "contractor_audit_scheduling.audit_name",
//     "contractor_audit_scheduling.audit_type",
//     "audit_category.description",
//     "contractor_audit_scheduling.opening_name_of_meeting",
//     "contractor_audit_scheduling.closing_name_of_meeting",
//     "audit_category.name",
//     "contractor_audit_scheduling.audit_scope",
//     "contractor_audit_scheduling.location",
//     "contractor_audit_scheduling.type_of_resources",
//     "contractor_audit_scheduling.status",
//     "contractor_audit_scheduling.critical_business_processes",
//   ];
//   /** If value come with any search condition then search that word */
//   let searchCondition = await searchConditionRecord(
//     req.query.search,
//     searchTableName
//   );

//   /**Make Joins according to tables */
//   const joins = [
//     {
//       type: "left",
//       targetTable: "audit_category",
//       onCondition:
//         "audit_category.id = contractor_audit_scheduling.audit_category",
//     },
//     {
//       type: "left",
//       targetTable: "users",
//       onCondition: "users.id = contractor_audit_scheduling.created_by",
//     },
//     {
//       type: "left",
//       targetTable: "organization",
//       onCondition: "organization.id = contractor_audit_scheduling.organization",
//     },
//     {
//       type: "left",
//       targetTable: "meeting as m1",
//       onCondition:
//         "m1.id = contractor_audit_scheduling.opening_name_of_meeting",
//     },
//     {
//       type: "left",
//       targetTable: "meeting as m2",
//       onCondition:
//         "m2.id = contractor_audit_scheduling.closing_name_of_meeting",
//     },
//     {
//       type: "left",
//       targetTable: "contractor_registration",
//       onCondition:
//         "contractor_registration.id = contractor_audit_scheduling.contractor",
//     },
//     {
//       type: "left",
//       targetTable: "contractor_registration AS contractAuditor",
//       onCondition: "contractAuditor.id = contractor_audit_scheduling.auditor",
//     },
//     {
//       type: "left",
//       targetTable: "project_registration",
//       onCondition:
//         "project_registration.id = contractor_audit_scheduling.project",
//     },
//   ];
//   const joinsRecord = await makeJoins(joins);

//   /**Record of all alert */
//   const auditSchedulingDataFetchQuery = `SELECT contractor_audit_scheduling.*,
//     audit_category.name as audit_category_name,
//     contractor_registration.contractor_name as contractor_name,
//     contractor_registration.cipc_registration_number AS contractor_cipc_registration_number,
//     contractor_audit_scheduling.created_by as created_by_id,
//     m1.meeting_title as opening_name_of_meeting_name,
//     m2.meeting_title as closing_name_of_meeting_name,
//     users.name as created_by_name ,contractor_audit_scheduling.organization,
//     organization.name as organization_name,
//     contractAuditor.contractor_name AS auditor_name
//     FROM contractor_audit_scheduling
//     ${joinsRecord}
//     where contractor_audit_scheduling.deleted = 0 ${searchCondition} ${condition}`;

//   let [auditSchedulingDataFetch] = await db.query(
//     auditSchedulingDataFetchQuery
//   );
//   auditSchedulingDataFetch = await decodeAndParseFields(
//     auditSchedulingDataFetch
//   );
//   for (const element of auditSchedulingDataFetch) {
//     if (element.audit_type == "Internal") {
//       element.auditor_lead_details = [];
//       if (element?.auditor_lead.length > 0) {
//         const [leads] = await db.query(
//           `SELECT CONCAT (name , surname ) AS name , id , profile from users where id in (${element?.auditor_lead})`
//         );
//         element.auditor_lead_details = leads;
//       }
//       element.auditor_members_details = [];
//       if (element?.auditor_members && element?.auditor_members.length > 0) {
//         const [members] = await db.query(
//           `SELECT CONCAT (name , surname ) AS name , id , profile from users where id in(${element?.auditor_members})`
//         );
//         element.auditor_members_details = members;
//       }
//     } else if (element.audit_type == "External") {
//       const projectId = element?.project;

//       const [projectMembers] = await db.query(
//         `SELECT project_members FROM project_registration WHERE id = ${projectId}`
//       );

//       let projectMembersArray = JSON.parse(projectMembers[0]?.project_members);

//       if (Array.isArray(element.auditor_lead)) {
//         element.auditor_lead_details = element.auditor_lead.map(
//           (auditorId) =>
//             projectMembersArray.find((member) => member.id === auditorId) ||
//             auditorId
//         );
//       } else {
//         element.auditor_lead_details =
//           projectMembersArray.find(
//             (member) => member.id === element.auditor_lead
//           ) || element.auditor_lead;
//       }

//       if (Array.isArray(element.auditor_members)) {
//         element.auditor_member_details = element.auditor_members.map(
//           (auditorId) =>
//             projectMembersArray.find((member) => member.id === auditorId) ||
//             auditorId
//         );
//       } else {
//         element.auditor_member_details =
//           projectMembersArray.find(
//             (member) => member.id === element.auditor_members
//           ) || element.auditor_members;
//       }
//     }
//     element.audit_focus_area_details = [];
//     if (element?.audit_focus_area.length > 0) {
//       const [focusArea] = await db.query(
//         `SELECT id, name from focus_area where id in (${element?.audit_focus_area})`
//       );
//       element.audit_focus_area_details = focusArea;
//     }

//     for (let i = 0; i < element.allocation_human_resource.length; i++) {
//       if (element.allocation_human_resource[i]?.role) {
//         const [role] = await db.query(
//           `SELECT id, name from roles where id = ${element.allocation_human_resource[i]?.role}`
//         );
//         element.allocation_human_resource[i].role_name = role[0]?.name;
//       }
//     }
//   }

//   /**Count all Contractor Audit Scheduling */
//   const totalRecord = await countQueryCondition(auditSchedulingDataFetchQuery);
//   return sendResponse(res, 200, auditSchedulingDataFetch, totalRecord);
// };

// /**Function to delete a specific Contractor Audit Scheduling */
// export const deleteContractorAuditScheduling = async (req, res) => {
//   const { id } = req.params;
//   const deleteRecordQuery = await deleteRecord(
//     "contractor_audit_scheduling",
//     id
//   );
//   if (deleteRecordQuery) {
//     /**Insert record for activity log */
//     insertActivityLog(
//       req.user.sessionid,
//       "delete",
//       "Contractor Audit Scheduling",
//       id
//     );
//     return sendResponse(res, 200, "Record deleted successfully");
//   }

//   return sendResponse(res, 400, "Record not deleted");
// };

import chalk from "chalk";
import db, { buildSelectQuery } from "../db-config.js";
import { uploadToDDRM } from "../helper/ddrmUploader.js";
import {
  countQueryCondition,
  createQueryBuilder,
  decodeAndParseFields,
  deleteRecord,
  encodeAndStringifyFields,
  getOrganizationAccordingToDepartment,
  getRecord,
  insertActivityLog,
  makeJoins,
  pointsCalculate,
  searchConditionRecord,
  uniqueIdGenerator,
  updateQueryBuilder,
  whereCondition,
} from "../helper/general.js";

import { sendResponse } from "../helper/wrapper.js";
import ContractorAuditRecord from "../sequelize/ContractorAuditRecordSchema.js";
import ContractorAuditScheduling from "../sequelize/ContractorAuditSchedulingSchema.js";
import { auditLinkedTable } from "../constants/constants.js";

export const createUpdateContractorAuditScheduling = async (req, res) => {
  let {
    id,
    department,
    schedule,
    evaluation_tool_status,
    sidebar_id = 274,
  } = req.body;
  schedule = JSON.parse(schedule);
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  let status = id ? "Updated" : "Created";

  if (department) {
    req.body.organization = (
      await getOrganizationAccordingToDepartment(department)
    )[0]?.organization;
  }
  // console.log(req.files, "req.files");
  //  return console.log(schedule);

  // for (
  //   let i = 0;
  //   req.body[`upload_documents[${i}][title]`] !== undefined;
  //   i++
  // ) {
  //   const id = i + 1;
  //   const title = req.body[`upload_documents[${i}][title]`];
  //   const file = req.files && req.files[`upload_documents[${i}][file]`];
  //   const classification = req.body[`upload_documents[${i}][classification]`];
  //   // Extract the index from the key
  //   // Assuming you want to store the file in a folder named "uploads"
  //   let filepath = "";
  //   if (
  //     typeof file !== "string" &&
  //     typeof file !== "undefined" &&
  //     file !== null
  //   ) {
  //     filepath = await uploadFile("attendance_recording", file);
  //   } else {
  //     filepath = req.body[`upload_documents[${i}][file]`];
  //   }
  //   // Move the file to the desired location
  //   // Push document information to the array
  //   documents.push({ id, title, file: filepath, classification });
  // }
  console.log(schedule);
  for (let i = 0; i < schedule.length; i++) {
    const sch = schedule[i];
    sch.lead_person = req.body[`schedule[${i}][lead_person]`];
    const cycle = sch.cycles || 1;
    const when = sch.repeat_when;
    // sch = await encodeAndStringifyFields(sch);
    if (sch.evaluation_tool_status === "Not Applicable") {
      if (req.body[`schedule[${i}][report]`]) {
        sch.report = req.body[`schedule[${i}][report]`];
        delete sch?.ddrm_id;
      }
      if (req.files && req.files[`schedule[${i}][report]`]) {
        const ddrm_id = await uploadToDDRM(
          sidebar_id,
          req.files[`schedule[${i}][report]`],
          req
        );
        sch.ddrm_id = ddrm_id;
        sch.status = "Executed";
      }
    }
    // sch = JSON.parse(sch);
    // console.log(sch, "sch");
    sch.id = id;
    sch.organization = req.body.organization;
    sch.department = req.body.department;
    sch.schedule_type = req.body.schedule_type;

    // Initial dates for first record in the cycle
    let planned_start_date = new Date(sch.planned_start_date);
    let planned_end_date = new Date(sch.planned_end_date);

    // console.log(cycle, "cycle");
    for (let i = 0; i < cycle; i++) {
      // Set dates for this cycle's audit entry
      sch.planned_start_date = planned_start_date.toISOString().split("T")[0];
      sch.planned_end_date = planned_end_date.toISOString().split("T")[0];

      if (!id) {
        const unique_id = await uniqueIdGenerator(
          sch.organization,
          sch.department,
          "ContractorAuditScheduling",
          "contractor_audit_scheduling",
          "unique_id",
          "unique_id"
        );
        sch.unique_id = unique_id;
      }

      const { query, values } = id
        ? updateQueryBuilder(ContractorAuditScheduling, sch)
        : createQueryBuilder(ContractorAuditScheduling, sch);

      // return console.log("query: ", query);
      const [result] = await db.query(query, values);

      await insertActivityLog(
        req.user.sessionid,
        status,
        "Contractor Audit Scheduling",
        id ? id : result.insertId
      );

      // Calculate the next cycle's dates based on `when` frequency
      switch (when) {
        case "Daily":
          planned_start_date.setDate(planned_start_date.getDate() + 1);
          planned_end_date.setDate(planned_end_date.getDate() + 1);
          break;
        case "Weekly":
          planned_start_date.setDate(planned_start_date.getDate() + 7);
          planned_end_date.setDate(planned_end_date.getDate() + 7);
          break;
        case "Monthly":
          planned_start_date.setMonth(planned_start_date.getMonth() + 1);
          planned_end_date.setMonth(planned_end_date.getMonth() + 1);
          break;
        case "Quarterly":
          planned_start_date.setMonth(planned_start_date.getMonth() + 3);
          planned_end_date.setMonth(planned_end_date.getMonth() + 3);
          break;
        case "Bi-Annually":
          planned_start_date.setMonth(planned_start_date.getMonth() + 6);
          planned_end_date.setMonth(planned_end_date.getMonth() + 6);
          break;
        case "Annually":
          planned_start_date.setFullYear(planned_start_date.getFullYear() + 1);
          planned_end_date.setFullYear(planned_end_date.getFullYear() + 1);
          break;
        default:
          break;
      }
    }
  }

  return sendResponse(res, 200, `Record ${status} Successfully`);
};

/**Function to view all Audit Scheduling */
export const viewAllContractorAuditScheduling = async (req, res) => {
  const { id } = req.params;
  const condition = await whereCondition({
    table: "contractor_audit_scheduling",
    page: req.query.page,
    all: req.query.all,
    pageSize: req.query.pageSize,
    filter: req.query.filter,
    id,
    user: req.user,
  });

  const searchTableName = [
    "contractor_audit_scheduling.contractor",
    "contractor_audit_scheduling.project",
    "contractor_audit_scheduling.linked_to",
    // "contractor_audit_scheduling.when",
    "contractor_audit_scheduling.cycles",
    "contractor_audit_scheduling.members",
    "contractor_audit_scheduling.owner",
    "contractor_audit_scheduling.participants",
    "contractor_audit_scheduling.scope",
    "contractor_audit_scheduling.critical_business",
    "contractor_audit_scheduling.financial_resource",
    "contractor_audit_scheduling.evaluation_tool",
    "organization.name",
    "audit_type.name"
  ];
  /** If value come with any search condition then search that word */
  let searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );

  /**Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "audit_type",
      onCondition: "audit_type.id = contractor_audit_scheduling.type",
    },
    {
      type: "left",
      targetTable: "sidebar AS Module",
      onCondition: "Module.id = contractor_audit_scheduling.module",
    },
    {
      type: "left",
      targetTable: "sidebar AS subModule",
      onCondition: "subModule.id = contractor_audit_scheduling.sub_module",
    },
    {
      type: "left",
      targetTable: "users",
      onCondition: "users.id = contractor_audit_scheduling.created_by",
    },
    {
      type: "left",
      targetTable: "users as owner",
      onCondition: "owner.id = contractor_audit_scheduling.owner",
    },
    {
      type: "left",
      targetTable: "organization",
      onCondition: "organization.id = contractor_audit_scheduling.organization",
    },
    {
      type: "left",
      targetTable: "contractor_audit_scheduling AS reference",
      onCondition:
        "reference.id = contractor_audit_scheduling.reference_number",
    },
    {
      type: "left",
      targetTable: "location",
      onCondition:
        "location.id = contractor_audit_scheduling.location",
    },
    {
      type: "left",
      targetTable: "currency as operating_budget_currency",
      onCondition:
        "operating_budget_currency.id = contractor_audit_scheduling.operating_budget_currency",
    },
    {
      type: "left",
      targetTable: "currency as capital_budget_currency",
      onCondition:
        "capital_budget_currency.id = contractor_audit_scheduling.capital_budget_currency",
    },
    {
      type: "left",
      targetTable: "repository",
      onCondition: "repository.id = contractor_audit_scheduling.ddrm_id",
    },
  ];
  const joinsRecord = await makeJoins(joins);

  /**Record of all alert */
  const auditSchedulingDataFetchQuery = `SELECT contractor_audit_scheduling.*, CONCAT(users.name , ' ' , users.surname) AS created_by_name , audit_type.name AS type_name , Module.title AS module_name , subModule.title AS sub_module_name , reference.name AS reference_number_name ,users.profile as created_by_profile, location.name as location_name ,organization.name as  organization_name , operating_budget_currency.name AS operating_budget_currency_name, capital_budget_currency.name AS capital_budget_currency_name, repository.url as file , CONCAT(owner.name , ' ' , owner.surname) AS owner_name FROM contractor_audit_scheduling  ${joinsRecord} WHERE contractor_audit_scheduling.deleted = 0 ${searchCondition} ${condition}`;

  let [auditSchedulingDataFetch] = await db.query(
    auditSchedulingDataFetchQuery
  );

  auditSchedulingDataFetch = await decodeAndParseFields(
    auditSchedulingDataFetch
  );

  for (let audit of auditSchedulingDataFetch) {
    // for specific record get name
    const linked_to = audit.linked_to;
    const record = audit.record_name;
    if (linked_to && record) {
      const tableName = auditLinkedTable[linked_to];
      const mappedFields = await buildSelectQuery(tableName);
      let query = `SELECT id, ${mappedFields} FROM ${tableName} WHERE deleted = 0 AND id = ${record}`;
      if (tableName === "permit_license_compliance") {
        query = `SELECT permit_license_compliance.id, permit_license.name as name FROM ${tableName} LEFT JOIN permit_license ON permit_license.id = permit_license_compliance.name WHERE permit_license_compliance.deleted = 0  AND permit_license_compliance.id = ${record}`;
      }
      const [result] = await db.query(query);
      audit.record_name_name = result[0]?.name;
    }
    const participants = audit.participants;
    const [partDetails] = await db.query(
      `SELECT CONCAT(name , ' '  , surname ) AS name , profile FROM users WHERE id IN (${participants})`
    );
    audit.participant_details = partDetails;
    let leadPersonDetails = [];
    const source = audit.source;
    if (audit?.lead_person?.some((person) => person !== null)) {
      const lead_persons = audit.lead_person;
      if (source == "Internal") {
        [leadPersonDetails] = await db.query(
          `SELECT CONCAT(name , ' '  , surname ) AS name , profile FROM users WHERE id IN (${lead_persons})`
        );
        if (audit.schedule_type === "certifications") {
          // get from contractor registration these lead person list
          [leadPersonDetails] = await db.query(
            `SELECT id , contractor_name as name FROM contractor_registration WHERE id IN (${lead_persons})`
          );
          audit.lead_person = leadPersonDetails;
        } else {
          audit.lead_person = audit.lead_person[0];
          audit.lead_person_name = leadPersonDetails[0]?.name;
          audit.lead_person_profile = leadPersonDetails[0]?.profile;
        }
      } else {
        const lead_persons = audit.lead_person;
        [leadPersonDetails] = await db.query(
          `SELECT * FROM contractor_registration WHERE id IN (${lead_persons})`
        );
        for (let leadPerson of leadPersonDetails) {
          leadPerson.lead_person_name = leadPerson.contractor_name;
        }
        audit.lead_person = leadPersonDetails;
      }
    }
    const members = audit.members;
    if (Array.isArray(members) && members.length > 0) {
      if (source == "Internal") {
        const [membersList] = await db.query(
          `SELECT CONCAT(users.name , ' ' , users.surname) AS name , users.profile AS profile FROM users WHERE users.id IN (${members}) `
        );
        audit.member_details = membersList;
      } else {
        const [membersList] = await db.query(
          `SELECT contractor_name FROM contractor_registration WHERE id IN (${members}) `
        );
        audit.member_details = membersList;
      }
    }
    const criticalBusiness = audit.critical_business;
    if (Array.isArray(criticalBusiness) && criticalBusiness.length > 0) {
      const [criticalBusinessList] = await db.query(
        `SELECT id,name FROM business_processes WHERE id IN (${criticalBusiness})`
      );
      audit.critical_business_details = criticalBusinessList;
    }
    const submoduleId = audit.sub_module;
    if (submoduleId) {
      const recordId = audit.record_name;

      const [submoduleData] = await db.query(
        `SELECT * FROM sidebar WHERE id = ${submoduleId}`
      );

      const subModule = submoduleData[0];
      const tableName = subModule.table_name;

      const [recordDetails] = await db.query(
        `SELECT * FROM ${tableName} WHERE id = ${recordId}`
      );

      if (recordDetails.length) {
        audit.record = recordDetails[0]?.name;
      }
    }

    audit.file = audit.file ? audit.file : "";

    // location for test-examination
    if (audit.schedule_type === "testing-examination") {
      let locationData = [];
      if (Array.isArray(audit.location) && audit.location.length > 0) {
        [locationData] = await db.query(
          `SELECT name FROM location WHERE id IN (${audit.location})`
        );
      }
      audit.location_name = locationData.map((item) => item.name);
    }
  }
  /**Count all Audit Scheduling */
  const totalRecord = await countQueryCondition(auditSchedulingDataFetchQuery);

  return sendResponse(res, 200, auditSchedulingDataFetch, totalRecord);
};

/**Function to delete a specific Audit Scheduling */
export const deleteContractorAuditScheduling = async (req, res) => {
  const { id } = req.params;
  const deleteRecordQuery = await deleteRecord(ContractorAuditScheduling, id);
  if (deleteRecordQuery) {
    /**Insert record for activity log */
    insertActivityLog(
      req.user.sessionid,
      "delete",
      "Contractor Audit Scheduling",
      id
    );
    return sendResponse(res, 200, "Record deleted successfully");
  }
};

/** function for adding audit record using audit template */
export const saveAuditRecord = async (req, res) => {
  const { id, organization, department, sections, audit_execution } = req.body;
  /** Check for audit execution is already executed or not  (by checking status)*/

  const [checkAuditExecution] = await db.query(
    "SELECT id, status FROM contractor_audit_scheduling WHERE id = ? AND deleted = 0",
    [audit_execution]
  );

  // console.log(chalk.grey(JSON.stringify(checkAuditExecution[0])));

  if (checkAuditExecution[0]?.status == "Executed") {
    return sendResponse(res, 400, "Audit Execution is already executed");
  }

  /**Check record if organization is not coming then fetch organization according to department */
  let organizationId = organization;
  if (department) {
    const recordAccordingToOrganization =
      await getOrganizationAccordingToDepartment(department);
    organizationId = recordAccordingToOrganization[0].organization;
    req.body.organization = organizationId;
  }

  const points = await pointsCalculate(sections);
  req.body.total_point = points.totalPoints;
  req.body.earned_points = points.pointsEarned;
  req.body.audit_record = req.body.sections;

  if (id) {
    const { query, values } = updateQueryBuilder(
      ContractorAuditRecord,
      req.body
    );
    await db.query(query, values);
    return sendResponse(res, 200, "Record updated successfully");
  }
  req.body.created_by = req.user.sessionid;

  const { query, values } = createQueryBuilder(ContractorAuditRecord, req.body);
  console.log(chalk.blue(query, values));
  const [createAuditRecord] = await db.query(query, values);
  // console.log(chalk.gray(JSON.stringify(createAuditRecord)));
  if (createAuditRecord.insertId > 0) {
    /** update status of audit execution  */
    const updateAuditExecutionQuery = `UPDATE contractor_audit_scheduling SET status=? , audit_record=? WHERE id=? AND deleted = 0`;
    await db.query(updateAuditExecutionQuery, [
      "Executed",
      createAuditRecord.insertId,
      audit_execution,
    ]);
    /**Insert record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "create",
      "Contractor Audit Execution Record",
      createAuditRecord.insertId
    );
    return sendResponse(res, 200, "Record created successfully");
  } else {
    return sendResponse(res, 200, "Record not created");
  }
};

export const uploadContractorReport = async (req, res) => {
  const {
    sidebar_id = 274,
    id,
    actual_start_date,
    actual_end_date,
    ddrm_id,
  } = req.body;
  // const report = req.files?.report;
  if (!ddrm_id) {
    return sendResponse(res, 400, "ddrm_id is required");
  }
  // const ddrm_id = await uploadToDDRM(sidebar_id, report, req);
  const { query, values } = updateQueryBuilder(ContractorAuditScheduling, {
    id,
    ddrm_id,
    actual_start_date,
    actual_end_date,
    status: "Executed",
  });
  const [result] = await db.query(query, values);
  if (result.affectedRows > 0) {
    return sendResponse(res, 200, "report uploaded successfully");
  } else {
    return sendResponse(res, 400, "Error uploading report");
  }
};

export const addContractorEvaluationTool = async (req, res) => {
  const { id, evaluation_tool_status, evaluation_tool } = req.body;
  if (!evaluation_tool) {
    return sendResponse(res, 400, "evaluation tool is required");
  }
  const { query, values } = updateQueryBuilder(ContractorAuditScheduling, {
    id,
    ...req.body,
  });
  const [result] = await db.query(query, values);
  if (result.affectedRows > 0) {
    return sendResponse(res, 200, "Tool added successfully");
  } else {
    return sendResponse(res, 400, "Error adding tool");
  }
};
