import db from "../db-config.js";
import {
  countQueryCondition,
  createQueryBuilder,
  decodeAndParseFields,
  deleteRecord,
  encodeAndStringifyFields,
  insertActivityLog,
  makeJoins,
  searchConditionRecord,
  updateQueryBuilder,
  uploadFile,
  whereCondition,
} from "../helper/general.js";

import { sendResponse } from "../helper/wrapper.js";
import ContractorPreSite from "../sequelize/ContractorPreSiteSchema.js";
import sendEmail from "../helper/sendEmail.js";
import ContractorPreSiteDocs from "../sequelize/ContractorPreSiteDocsSchema.js";
import PreSiteResponses from "../sequelize/PreSiteResponsesSchema.js";

export const createUpdateContractorPreSite = async (req, res) => {
  const { id, contractors } = req.body;

  let status = id ? "Updated" : "Created";
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  if (contractors && Array.isArray(contractors)) {
    for (const contractor of contractors) {
      const [check] = await db.query(
        `SELECT * FROM contractor_pre_site WHERE contractor = ${contractor} AND deleted = 0`
      );
      if (check.length > 0) {
        continue;
      }
      const [fetchOrg] = await db.query(
        `SELECT * FROM contractor_registration WHERE id = ${contractors[0]}`
      );
      req.body.organization = fetchOrg[0]?.organization;
      req.body.department = fetchOrg[0]?.department;
      req.body.contractor = contractor;
      req.body.status = "Not Sent";
      req.body = await encodeAndStringifyFields(req.body);

      const { query, values } = id
        ? updateQueryBuilder(ContractorPreSite, req.body)
        : createQueryBuilder(ContractorPreSite, req.body);
      const [result] = await db.query(query, values);

      req.body.public_url = `contractor-pre-site/fill/${
        id ? id : result.insertId
      }`;
      await db.query(
        `UPDATE contractor_pre_site SET public_url = '${
          req.body.public_url
        }' WHERE id = ${id ? id : result.insertId}`
      );

      await insertActivityLog(
        req.user.sessionid,
        status,
        "Contractor PreSite",
        id ? id : result.insertId
      );
      // send email
    }
  }

  return sendResponse(res, 200, `Record ${status} Successfully`);
};

// export const getContractorPreSite = async (req, res) => {
//   const { id } = req.params;
//   const condition = await whereCondition({
//     table: "contractor_pre_site",
//     page: req.query.page,
//     all: req.query.all,
//     pageSize: req.query.pageSize,
//     filter: req.query.filter,
//     id,
//     grouped: req.query.grouped,
//     user: req.user,
//   });

//   const searchTableName = [
//     "contractor_registration.contractor_name",
//     "CONCAT(users.name , ' ' , users.surname)",
//   ];

//   const searchCondition = await searchConditionRecord(
//     req.query.search,
//     searchTableName
//   );

//   const joins = [
//     {
//       type: "left",
//       targetTable: "users",
//       onCondition: "users.id = contractor_pre_site.created_by",
//     },
//     {
//       type: "left",
//       targetTable: "contractor_registration",
//       onCondition:
//         "contractor_registration.id = contractor_pre_site.contractor",
//     },
//   ];

//   const joinCondition = await makeJoins(joins);

//   const contractorPreSiteQuery = `SELECT contractor_pre_site.* , CONCAT(users.name , ' ' , users.surname) AS created_by_name , contractor_registration.contractor_name AS contractor_name , contractor_registration.cipc_registration_number AS contractor_cipc_registration_number  FROM contractor_pre_site ${joinCondition} WHERE contractor_pre_site.deleted = 0 ${searchCondition} ${condition}`;

//   let [contractorPreSite] = await db.query(contractorPreSiteQuery);

//   contractorPreSite = await decodeAndParseFields(contractorPreSite);

//   for (const record of contractorPreSite) {
//     const [responses] = await db.query(
//       `SELECT pre_site_responses.* , contractor_forms.form , contractor_forms.name FROM pre_site_responses LEFT JOIN contractor_forms ON pre_site_responses.contractor_pre_site_form = contractor_forms.id WHERE pre_site_responses.contractor_pre_site_id = ${record.id} AND pre_site_responses.deleted = 0`
//     );
//     for (const response of responses) {
//       response.form = Array.isArray(response.form)
//         ? response.form
//         : JSON.parse(response.form);
//       const [docs] = await db.query(
//         `SELECT * FROM contractor_pre_site_docs WHERE pre_site_response_id = ${response.id} AND deleted = 0`
//       );
//       response.images = docs;
//     }
//     // const id = record.id;
//     record.response_received = responses;
//   }

//   const totalRecord = await countQueryCondition(contractorPreSiteQuery);

//   return sendResponse(res, 200, contractorPreSite, totalRecord);
// };

export const getContractorPreSite = async (req, res) => {
  const { id } = req.params;
  const condition = await whereCondition({
    table: "contractor_pre_site",
    page: req.query.page,
    all: req.query.all,
    pageSize: req.query.pageSize,
    filter: req.query.filter,
    id,
    grouped: req.query.grouped,
    user: req.user,
  });

  const searchTableName = [
    "contractor_registration.contractor_name",
    "CONCAT(users.name , ' ' , users.surname)",
  ];

  const searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );

  const joins = [
    {
      type: "left",
      targetTable: "users",
      onCondition: "users.id = contractor_pre_site.created_by",
    },
    {
      type: "left",
      targetTable: "contractor_registration",
      onCondition:
        "contractor_registration.id = contractor_pre_site.contractor",
    },
  ];

  const joinCondition = await makeJoins(joins);

  const contractorQuestionnaireQuery = `SELECT contractor_pre_site.* , CONCAT(users.name , ' ' , users.surname) AS created_by_name , contractor_registration.contractor_name AS contractor_name , contractor_registration.cipc_registration_number AS contractor_cipc_registration_number FROM contractor_pre_site ${joinCondition} WHERE contractor_pre_site.deleted = 0 ${searchCondition} ${condition}`;

  let [contractorQuestionnaire] = await db.query(contractorQuestionnaireQuery);

  // contractorQuestionnaire = await decodeAndParseFields(contractorQuestionnaire);

  for (const record of contractorQuestionnaire) {
    let [responses] = await db.query(
      `SELECT * FROM pre_site_responses WHERE contractor_pre_site_id = ${record.id} AND deleted = 0`
    );
    responses = await decodeAndParseFields(responses);
    console.log("responses: ", responses[0]?.form);
    for (const response of responses) {
      // console.log('response: ', response);
      const [docs] = await db.query(
        `SELECT * FROM contractor_pre_site_docs WHERE pre_site_response_id = ${response.id} AND deleted = 0`
      );
      const [form_template] = response.contractor_pre_site_form
        ? await db.query(
            `SELECT * FROM contractor_forms WHERE id = ${response.contractor_pre_site_form}`
          )
        : [null];

      form_template?.forEach((ele) => {
        ele.form = ele?.form ? JSON.parse(ele.form) : ele.form;
      });
      if (form_template && form_template.length > 0) {
        response.form_template = form_template[0].form;
      }
      // response.form = form_template[0].form;
      response.images = docs;

      response.contractor = record.contractor;
      response.contractor_name = record.contractor_name;
      response.contractor_cipc_registration_number =
        record.contractor_cipc_registration_number;
      response.organization = record.organization;
      response.unique_id = record.unique_id;
    }
    // const id = record.id;
    record.response_received = responses;
  }

  const totalRecord = await countQueryCondition(contractorQuestionnaireQuery);

  return sendResponse(res, 200, contractorQuestionnaire, totalRecord);
};

export const deleteContractorPreSite = async (req, res) => {
  const { id } = req.params;

  await deleteRecord(ContractorPreSite, id);
  await insertActivityLog(
    req.user.sessionid,
    "delete",
    "Contractor PreSite",
    id
  );

  return sendResponse(res, 200, "Record deleted successfully");
};

export const sendPreSite = async (req, res) => {
  const { id, url, name, contractor_pre_site_form, project } = req.body;
  const total = name.length;
  for (const i of name) {
    i.contractor_pre_site_form = contractor_pre_site_form;
    i.project = project;
    const { query, values } = createQueryBuilder(PreSiteResponses, {
      ...i,
      contractor_pre_site_id: id,
    });
    const [result] = await db.query(query, values);
    const link = url + "/" + result.insertId;

    const sendRecordArray = {
      templateFileUrl: "mail_for_pre_site_template.html",
      link: link,
      name: i.title,
      templateName: "Pre Site",
    };

    const info = await sendEmail(
      "info@harmonyandhelp.com",
      i.employee_email,
      "PreSite Response",
      sendRecordArray
    );

    if (info) {
      await db.query(
        `UPDATE contractor_pre_site SET status = 'Response Pending' , total = ${total} , responses = 0 WHERE id = ${id}`
      );
    } else
      return sendResponse(res, 400, "PreSite sending failed. Please try again");
  }
  return sendResponse(res, 200, "PreSite sent to email successfully");
};

// id, organization, contractor, cipc, project, contractor_pre_site_form;

export const fillForm = async (req, res) => {
  const { id } = req.body;
  const [dataFetch] = await db.query(
    `SELECT * FROM pre_site_responses WHERE id = ${id}`
  );
  let form = req.body;
  delete req.body.contractor;
  delete req.body.project;
  if (dataFetch[0]?.status === "Response Received") {
    return sendResponse(res, 400, "Response already submitted");
  }
  // console.log(req.files);

  let document = [];

  // for (let i = 0; i <= 10; i++) {
  //   if ((req?.files && req.files[`document[${i}]`]) || req.body[`document[${i}]`]) {
  //     const file = req.files[`document[${i}]`];
  //     if (typeof file != "string" && typeof file == "object") {
  // const filePath = await uploadFile("contractor_pre_site", file);
  //       document.push({ file: filePath, doc_no: i });
  //     } else {
  //       document.push({ file: req.body[`document[${i}]`], doc_no: i });
  //     }
  //   }
  // }

  await deleteRecord(ContractorPreSiteDocs, id, "pre_site_response_id");

  req.body = await encodeAndStringifyFields(req.body);
  form.status = "Response Received";
  const { query, values } = updateQueryBuilder(PreSiteResponses, form);
  const [result] = await db.query(query, values);

  // for (let doc of document) {
  //   const { query, values } = createQueryBuilder(ContractorPreSiteDocs, {
  //     ...doc,
  //     pre_site_response_id: id ? id : result.insertId,
  //   });
  //   await db.query(query, values);
  // }

  if (result.affectedRows > 0) {
    // also update status to Response Received if number of response equal to total response
    const [contractorPreSite] = await db.query(
      `SELECT * FROM contractor_pre_site WHERE id = ${dataFetch[0].contractor_pre_site_id}`
    );
    let status = "";
    if (contractorPreSite[0].total === contractorPreSite[0].responses + 1) {
      status = `, status = 'Response Received'`;
    }
    await db.query(
      `UPDATE contractor_pre_site SET responses = responses + 1 ${status} WHERE id = ${dataFetch[0].contractor_pre_site_id}`
    );
    return sendResponse(res, 200, "Form Filled successfully");
  }
  return sendResponse(res, 400, "Record Not updated");
};

export const enableDisableForm = async (req, res) => {
  const { id, status } = req.body;
  const [update] = await db.query(
    `UPDATE contractor_pre_site SET status = ?  WHERE id = ?`,
    [status, id]
  );
  if (update.affectedRows > 0) {
    return sendResponse(res, 200, "Status updated successfully");
  }
  return sendResponse(
    res,
    400,
    "Some error occurred while updating the status "
  );
};
