import db from "../db-config.js";
import { sendResponse } from "../helper/wrapper.js";
import {
  insertActivityLog,
  searchConditionRecord,
  makeJoins,
  whereCondition,
  countQueryCondition,
  settingsUpdater,
  deleteSettingRecord,
  encodeSingle_statement,
  decodeSingle_statement,
  uniqueIdGenerator,
  getFirstCreatedAndAllOrganizationIds,
  getRecord,
  getListingData,
  getFilterConditions,
} from "../helper/general.js";
import DefectDetectionMethod from "../sequelize/DefectDetectionMethodSchema.js";
import {
  createQueryBuilder,
  updateQueryBuilder,
} from "../helper/queryBuilder.js";

/** Function to create or update DefectDetectionMethod */
export const createUpdateDefectDetectionMethod = async (req, res) => {
  const { id, name, description, organization } = req.body;
  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();

    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "DefectDetectionMethod",
      "defect_detection_method",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization =
      organization.length > 0 ? organization : result.organizationIds;
  }
  const encodedDescription = await encodeSingle_statement(description);
  req.body.description = encodedDescription;
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  /**If id comes in body then it will update the query */
  const [checkNameWithOrganization] = await getRecord(
    "defect_detection_method",
    "name",
    name
  );
  if (checkNameWithOrganization) {
    if (id && checkNameWithOrganization.id != id) {
      return sendResponse(res, 400, "DefectDetectionMethod name already exist");
    } else if (!id) {
      return sendResponse(
        res,
        400,
        "DefectDetectionMethod name name  already exist"
      );
    }
  }
  if (id) {
    /**Check that this organization have that particular name or not*/
    if (organization.length === 0) {
      return sendResponse(
        res,
        400,
        "Please Select at least one business Structure"
      );
    }

    /**update query */
    const { query, values } = updateQueryBuilder(
      DefectDetectionMethod,
      req.body
    );
    await db.query(query, values);
    /**Update record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "update",
      "DefectDetectionMethod",
      id
    );
    return sendResponse(res, 200, "Record updated successfully");
  } else {
    const { query, values } = createQueryBuilder(
      DefectDetectionMethod,
      req.body
    );
    const result = await db.query(query, values);
    /**Insert record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "create",
      "DefectDetectionMethod",
      result.insertId
    );
    return sendResponse(res, 200, "Record created successfully");
  }

  // const encodedDescription = await encodeSingle_statement(description);

  // if (id) {
  //   const result = await settingsUpdater(
  //     DefectDetectionMethod,
  //     req.body.organization,
  //     req.body,
  //     req.user
  //   );
  //   if (!result) {
  //     return sendResponse(res, 404, "No data found");
  //   }
  //   await insertActivityLog(req.user.sessionid, "update", "DefectDetectionMethod", `This user updated DefectDetectionMethod with id: ${id}`);
  //   return sendResponse(res, 200, "Record updated successfully");
  // } else {
  //   const insertPromises = req.body.organization.map(async (org) => {
  //     const [checkName] = await db.query(`SELECT name FROM defect_detection_method WHERE name = ? AND deleted = 0 AND organization = ?`, [name, org]);
  //     if (checkName.length === 0) {
  //       const unique_id = await uniqueIdGenerator(
  //         org,
  //         req?.body?.department,
  //         "DDM",
  //         "defect_detection_method",
  //         "unique_id",
  //         "unique_id"
  //       );
  //       await db.query(`INSERT INTO defect_detection_method (name, description, created_by, organization,unique_id) VALUES (?,?, ?, ?, ?)`, [name, encodedDescription, req.user.sessionid, org,unique_id]);
  //       await insertActivityLog(req.user.sessionid, "create", "DefectDetectionMethod", `This user created a new DefectDetectionMethod '${name}' for organization ${org}`);
  //     }
  //   });
  //   await Promise.all(insertPromises);
  //   return sendResponse(res, 200, "Record created successfully");
  // }
};

/** Function to view all or single DefectDetectionMethod */
export const viewDefectDetectionMethod = async (req, res) => {
  
  let { organizationCondition, condition } = await getFilterConditions(
    req,
    db,
    "defect_detection_method"
  );
  /** If value come with any search condition then search that word */
  const searchTableName = [
    "defect_detection_method.name",
    "defect_detection_method.description",
    "createdUser.name",
  ];
  /** If value come with any search condition then search that word */
  let searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );
  /**Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "users as createdUser",
      onCondition: "createdUser.id = defect_detection_method.created_by",
    },
  ];
  const joinsRecord = await makeJoins(joins);
  /**Record of all Skill */
  let defectDetectionQuery = `SELECT 
  defect_detection_method.*, 
  defect_detection_method.organization AS organizations, 
  createdUser.name AS created_by, 
  createdUser.surname AS created_by_surname, 
  createdUser.id AS created_by_id, 
  createdUser.profile AS created_by_profile
FROM defect_detection_method
${joinsRecord} 
WHERE defect_detection_method.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;

  // console.log(skillQuery, "skillQuery");
  let [defectDetection] = await db.query(defectDetectionQuery);
  defectDetection = await getListingData(defectDetection);
  /**Count all organization */
  const totalRecord = await countQueryCondition(defectDetectionQuery);
  return sendResponse(res, 200, defectDetection, totalRecord);
 
  
  
  
  
  
  // const { id } = req.params;
  // const condition = await whereCondition({
  //   table: "defect_detection_method",
  //   page: req.query.page,
  //   all: req.query.all,
  //   pageSize: req.query.pageSize,
  //   filter: req.query.filter,
  //   id,
  //   user: req.user,
  //   grouped: req.query.grouped,
  // });

  // const searchFields = [
  //   "defect_detection_method.name",
  //   "defect_detection_method.description",
  //   "users.name",
  //   "organization.name",
  // ];
  // let searchCondition = await searchConditionRecord(
  //   req.query.search,
  //   searchFields
  // );
  // const joins = [
  //   {
  //     type: "left",
  //     targetTable: "users",
  //     onCondition: "users.id = defect_detection_method.created_by",
  //   },
  //   {
  //     type: "left",
  //     targetTable: "organization",
  //     onCondition: "organization.id = defect_detection_method.organization",
  //   },
  // ];
  // const joinsRecord = await makeJoins(joins);

  // const fetchQuery = `SELECT defect_detection_method.*, CONCAT(users.name, ' ', users.surname) AS created_by, organization.name AS organization_name FROM defect_detection_method ${joinsRecord} WHERE defect_detection_method.deleted = 0 ${searchCondition} ${condition}`;
  // let [records] = await db.query(fetchQuery);

  // for (const record of records) {
  //   record.description = await decodeSingle_statement(record.description);
  //   if (req.query.grouped == "true") {
  //     const [organizations] = await db.query(
  //       `SELECT organization FROM defect_detection_method WHERE deleted = 0 AND name = ?`,
  //       [record.name]
  //     );
  //     const arr = organizations.map((item) => item.organization);
  //     record.organizations = arr;
  //   }
  // }

  // const totalRecord = await countQueryCondition(fetchQuery);
  // return sendResponse(res, 200, records, totalRecord);
};

/** Function to delete DefectDetectionMethod */
export const deleteDefectDetectionMethod = async (req, res) => {
  const { id } = req.params;
  const deleteRecord = await deleteSettingRecord("defect_detection_method", id);
  if (deleteRecord) {
    await insertActivityLog(
      req.user.sessionid,
      "delete",
      "DefectDetectionMethod",
      id
    );
    return sendResponse(res, 200, "Record deleted successfully");
  } else {
    return sendResponse(res, 404, "Record not found");
  }
};
