import db from "../db-config.js";
import { sendResponse } from "../helper/wrapper.js";
import {
  insertActivityLog,
  searchConditionRecord,
  makeJoins,
  whereCondition,
  countQueryCondition,
  deleteSettingRecord,
  encodeSingle_statement,
  decodeSingle_statement,
  settingsUpdater,
  uniqueIdGenerator,
  getRecord,
  getFirstCreatedAndAllOrganizationIds,
  getListingData,
  getFilterConditions,
} from "../helper/general.js";
import DocumentClassification from "../sequelize/DocumentClassificationSchema.js";
import {
  createQueryBuilder,
  updateQueryBuilder,
} from "../helper/queryBuilder.js";

/** Function to create or update DocumentClassification */
export const createUpdateDocumentClassification = async (req, res) => {
  const { id, name, description, organization } = req.body;

  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();

    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "DocumentClassification",
      "document_classification",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization =
      organization.length > 0 ? organization : result.organizationIds;
  }
  const encodedDescription = await encodeSingle_statement(description);
  req.body.description = encodedDescription;
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  /**If id comes in body then it will update the query */
  const [checkNameWithOrganization] = await getRecord(
    "document_classification",
    "name",
    name
  );
  if (checkNameWithOrganization) {
    if (id && checkNameWithOrganization.id != id) {
      return sendResponse(
        res,
        400,
        "Document Classification name already exist"
      );
    } else if (!id) {
      return sendResponse(
        res,
        400,
        "Document Classification name already exist"
      );
    }
  }
  if (id) {
    /**Check that this organization have that particular name or not*/
    if (organization.length === 0) {
      return sendResponse(
        res,
        400,
        "Please Select at least one business Structure"
      );
    }

    /**update query */
    const { query, values } = updateQueryBuilder(
      DocumentClassification,
      req.body
    );
    await db.query(query, values);
    /**Update record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "update",
      "DocumentClassification",
      id
    );
    return sendResponse(res, 200, "Record updated successfully");
  } else {
    const { query, values } = createQueryBuilder(
      DocumentClassification,
      req.body
    );
    const result = await db.query(query, values);
    /**Insert record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "create",
      "DocumentClassification",
      result.insertId
    );
    return sendResponse(res, 200, "Record created successfully");
  }

  // const encodedDescription = await encodeSingle_statement(description);

  // if (id) {
  //   const result = await settingsUpdater(
  //     DocumentClassification,
  //     req.body.organization,
  //     req.body,
  //     req.user
  //   );
  //   if (!result) {
  //     return sendResponse(res, 404, "No data found");
  //   }
  //   await insertActivityLog(req.user.sessionid, "update", "DocumentClassification", `This user updated DocumentClassification with id: ${id}`);
  //   return sendResponse(res, 200, "Record updated successfully");
  // } else {
  //   const insertPromises = req.body.organization.map(async (org) => {
  //     const [checkName] = await db.query(`SELECT name FROM document_classification WHERE name = ? AND deleted = 0 AND organization = ?`, [name, org]);
  //     if (checkName.length === 0) {

  //         const unique_id = await uniqueIdGenerator(
  //           org,
  //           req?.body?.department || null,
  //           "DocumentClassification",
  //           "document_classification",
  //           "unique_id",
  //           "unique_id"
  //         );
  //         req.body.unique_id = unique_id;

  //       await db.query(`INSERT INTO document_classification (name, description, created_by, organization,unique_id) VALUES (?, ?, ?, ?,?)`, [name, encodedDescription, req.user.sessionid, org,unique_id]);
  //       await insertActivityLog(req.user.sessionid, "create", "DocumentClassification", `This user created a new DocumentClassification '${name}' for organization ${org}`);
  //     }
  //   });
  //   await Promise.all(insertPromises);
  //   return sendResponse(res, 200, "Record created successfully");
  // }
};

/** Function to view all or single DocumentClassification */
export const viewDocumentClassification = async (req, res) => {
  let { organizationCondition, condition } = await getFilterConditions(
    req,
    db,
    "document_classification"
  );
  /** If value come with any search condition then search that word */
  const searchTableName = [
    "document_classification.name",
    "document_classification.description",
    "createdUser.name",
  ];
  /** If value come with any search condition then search that word */
  let searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );
  /**Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "users as createdUser",
      onCondition: "createdUser.id = document_classification.created_by",
    },
  ];
  const joinsRecord = await makeJoins(joins);
  /**Record of all Skill */
  let documentClassificationQuery = `SELECT 
  document_classification.*, 
  document_classification.organization AS organizations, 
  createdUser.name AS created_by, 
  createdUser.surname AS created_by_surname, 
  createdUser.id AS created_by_id, 
  createdUser.profile AS created_by_profile
FROM document_classification
${joinsRecord} 
WHERE document_classification.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;

  // console.log(skillQuery, "skillQuery");
  let [documentClassification] = await db.query(documentClassificationQuery);
  documentClassification = await getListingData(documentClassification);
  /**Count all organization */
  const totalRecord = await countQueryCondition(documentClassificationQuery);
  return sendResponse(res, 200, documentClassification, totalRecord);

  // const { id } = req.params;
  // const condition = await whereCondition({
  //   table: "document_classification",
  //   page: req.query.page,
  //   all: req.query.all,
  //   pageSize: req.query.pageSize,
  //   filter: req.query.filter,
  //   id,
  //   user: req.user,
  //   grouped: req.query.grouped,
  // });

  // const searchFields = [
  //   "document_classification.name",
  //   "document_classification.description",
  //   "users.name",
  //   "organization.name",
  // ];
  // let searchCondition = await searchConditionRecord(
  //   req.query.search,
  //   searchFields
  // );
  // const joins = [
  //   {
  //     type: "left",
  //     targetTable: "users",
  //     onCondition: "users.id = document_classification.created_by",
  //   },
  //   {
  //     type: "left",
  //     targetTable: "organization",
  //     onCondition: "organization.id = document_classification.organization",
  //   },
  // ];
  // const joinsRecord = await makeJoins(joins);

  // const fetchQuery = `SELECT document_classification.*, CONCAT(users.name, ' ', users.surname) AS created_by, organization.name AS organization_name FROM document_classification ${joinsRecord} WHERE document_classification.deleted = 0 ${searchCondition} ${condition}`;
  // let [records] = await db.query(fetchQuery);

  // for (const record of records) {
  //   record.description = await decodeSingle_statement(record.description);
  //   if (req.query.grouped == "true") {
  //     const [organizations] = await db.query(
  //       `SELECT organization FROM document_classification WHERE deleted = 0 AND name = ?`,
  //       [record.name]
  //     );
  //     const arr = organizations.map((item) => item.organization);
  //     record.organizations = arr;
  //   }
  // }

  // const totalRecord = await countQueryCondition(fetchQuery);
  // return sendResponse(res, 200, records, totalRecord);
};

/** Function to delete DocumentClassification */
export const deleteDocumentClassification = async (req, res) => {
  const { id } = req.params;
  const deleteRecord = await deleteSettingRecord("document_classification", id);
  if (deleteRecord) {
    await insertActivityLog(
      req.user.sessionid,
      "delete",
      "DocumentClassification",
      id
    );
    return sendResponse(res, 200, "Record deleted successfully");
  } else {
    return sendResponse(res, 404, "Record not found");
  }
};
