import db from "../db-config.js";
import {
  countQueryCondition,
  decodeAndParseFields,
  decodeSingle_statement,
  deleteFile,
  deleteRecord,
  encodeAndStringifyFields,
  encodeSingle_statement,
  getOrganizationAccordingToDepartment,
  getRecord,
  incidentCategoryConstant,
  insertActivityLog,
  insertNotification,
  makeJoins,
  processUploadDocuments,
  searchConditionRecord,
  uniqueIdGenerator,
  uploadFile,
  whereCondition,
} from "../helper/general.js";
import { sendResponse } from "../helper/wrapper.js";
import {
  createQueryBuilder,
  updateQueryBuilder,
} from "../helper/queryBuilder.js";
import Incident from "../sequelize/IncidentSchema.js";
import IncidentDocs from "../sequelize/IncidentDocsSchema.js";
import { uploadToDDRM } from "../helper/ddrmUploader.js";

/**Function to create and update Incident  */
export const createUpdatedIncident = async (req, res) => {
  req.body = (await decodeAndParseFields([req.body]))[0];
  const {
    id,
    description,
    current_impact,
    potential_impact,
    organization,
    department,
    notification,
    sidebarId = 173,
  } = req.body;
  req.body.notification = notification
    .map((user) => user.user_id)
    .filter((user) => user);
  req.body.description = await encodeSingle_statement(description);
  req.body.current_impact = await encodeSingle_statement(current_impact);
  req.body.potential_impact = await encodeSingle_statement(potential_impact);

  const documents = await processUploadDocuments(
    req,
    sidebarId,
    "photographs_incident"
  );
  if (id && documents.length) {
    const deleteQuery = `UPDATE incident_docs SET deleted = 1 where deleted = 0 AND incident_id = ?`;
    await db.query(deleteQuery, [id]);
  }
  // console.log(notification, "notification");
  for (const i of req.body.notification) {
    await insertNotification(
      "Incident",
      "An incident has occurred",
      i,
      "text",
      req.user.sessionid
    );
  }

  // Iterate through the request body keys
  // for (let i = 0; req.body[`photographs_incident[${i}][title]`] !== undefined; i++) {
  //   const id = i + 1;
  //   const title = req.body[`photographs_incident[${i}][title]`];
  //   const file_classification = req.body[`photographs_incident[${i}][file_classification]`];
  //   const file = req.files && req.files[`photographs_incident[${i}][file]`];

  //   let ddrm_id = "";
  //   if (typeof file !== "string" && typeof file !== "undefined" && file !== null) {
  //     ddrm_id = await uploadToDDRM(sidebarId, file, req);
  //   } else {
  //     //do nothing no need to update
  //     // ddrm_id = req.body[`photographs_incident[${i}][file]`];
  //   }
  //   // Move the file to the desired location
  //   // Push document information to the array
  //   documents.push({ id, title, ddrm_id, file_classification });
  // }
  // console.log(documents);
  //

  /**Check record if organization is not coming then fetch organization according to department */
  let organizationId = organization;
  if (department) {
    const recordAccordingToOrganization =
      await getOrganizationAccordingToDepartment(department);
    organizationId = recordAccordingToOrganization[0].organization;
    req.body.organization = organizationId;
  }

  let repository_ids = [];
  // if (id) {
  //   //get all previous documents from incident_docs and extract ddrm_ids
  //   const [documents] = await db.query(`SELECT ddrm_id FROM incident_docs WHERE deleted = 0 AND incident_id = ?`, [id]);
  //   repository_ids = documents.map((doc) => doc.ddrm_id);
  // }
  /**If id comes in body then it will update the query */
  if (id) {
    let existingIncident = [];
    [existingIncident] = await db.query(
      `SELECT is_done FROM incident WHERE id = ${id}`
    );
    if (existingIncident[0].is_done === 1) {
      return sendResponse(
        res,
        409,
        "Investigation for this incident has already been completed"
      );
    }
    req.body.updated_by = req.user.sessionid;
    req.body = await encodeAndStringifyFields(req.body);

    if (!id) {
      const unique_id = await uniqueIdGenerator(
        req.body.organization,
        department,
        "INC",
        "incident",
        "unique_id",
        "unique_id"
      );
      req.body.unique_id = unique_id;
    }

    const { query, values } = updateQueryBuilder(Incident, req.body);
    // console.log(query, values);

    let [updateIncident] = await db.query(query, values);

    // if (documents.length) {
    //   //update the repository ids is_archived
    //   if (repository_ids.length > 0) {
    //     await db.query(`UPDATE repository SET is_archived = 1 where deleted = 0 AND id IN (?)`, [repository_ids]);
    //   }
    //   const deleteQuery = `UPDATE incident_docs SET deleted = 1 where deleted = 0 AND incident_id = ?`;
    //   await db.query(deleteQuery, [id]);
    // }

    // if (updateIncident.affectedRows !== 0) {
    //   if (documents || Array.isArray(documents)) {
    //     // Iterate through uploaded files
    //     for (const file of documents) {
    //       const title = file.title; // Use file name as title
    //       const ddrm_id = file.ddrm_id;
    //       const id_doc = file.id;
    //       const file_classification = file.file_classification;
    //       // Move the file to the public folder
    //       // Save file details for database
    //       const { query: docQuery, values: docValues } = createQueryBuilder(IncidentDocs, {
    //         doc_no: id_doc,
    //         incident_id: id ? id : result.insertId,
    //         title,
    //         ddrm_id,
    //         file_classification,
    //       });
    //       await db.query(docQuery, docValues);
    //     }
    //   }
    // }

    if (documents || Array.isArray(documents)) {
      // Iterate through uploaded files
      let i = 1;
      for (const file of documents) {
        const title = file.title; // Use file name as title
        const ddrm_id = file?.ddrm_id;
        const id_doc = file.id || i++;
        const file_classification = file?.file_classification || null;
        // Move the file to the public folder
        // Save file details for database
        const { query: docQuery, values: docValues } = createQueryBuilder(
          IncidentDocs,
          {
            doc_no: id_doc,
            incident_id: id,
            title,
            ddrm_id,
            file_classification,
          }
        );

        await db.query(docQuery, docValues);
      }
    }

    /**Insert record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "update",
      "Incident",
      `This user Update Incident which id is ${id}`
    );

    return sendResponse(res, 200, "Record updated successfully");
  } else {
    const unique_id = await uniqueIdGenerator(
      req.body.organization,
      department,
      "INC",
      "incident",
      "unique_id",
      "unique_id"
    );
    const type = "reference";
    const reference_no = await uniqueIdGenerator(
      req.body.organization,
      department,
      "INC",
      "incident",
      "reference_no",
      type
    );
    req.body.unique_id = unique_id;
    req.body.reference_no = reference_no;

    /** Insert Incident details */
    req.body.created_by = req.user.sessionid;
    req.body = await encodeAndStringifyFields(req.body);
    const { query, values } = createQueryBuilder(Incident, req.body);
    let [insertIncidentUpdate] = await db.query(query, values);

    // if (insertIncidentUpdate.insertId !== 0) {
    //   if (documents && Array.isArray(documents)) {
    //     // Iterate through uploaded files
    //     for (const file of documents) {
    //       const title = file.title; // Use file name as title
    //       const ddrm_id = file.ddrm_id;
    //       const id_doc = file.id;
    //       const file_classification = file?.file_classification || null;
    //       // Move the file to the public folder
    //       // Save file details for database
    //       const { query: docQuery, values: docValues } = createQueryBuilder(IncidentDocs, {
    //         doc_no: id_doc,
    //         incident_id: id ? id : insertIncidentUpdate.insertId,
    //         title,
    //         ddrm_id,
    //         file_classification,
    //       });
    //       await db.query(docQuery, docValues);
    //     }
    //   }
    // }

    if (documents || Array.isArray(documents)) {
      // console.log("documents: ", documents);
      // Iterate through uploaded files
      let i = 1;
      for (const file of documents) {
        const title = file.title; // Use file name as title
        const ddrm_id = file?.ddrm_id;
        const id_doc = file.id || i++;
        const file_classification = file?.file_classification || null;
        // Move the file to the public folder
        // Save file details for database
        const { query: docQuery, values: docValues } = createQueryBuilder(
          IncidentDocs,
          {
            doc_no: id_doc,
            incident_id: insertIncidentUpdate.insertId,
            title,
            ddrm_id,
            file_classification,
          }
        );

        await db.query(docQuery, docValues);
      }
    }

    /** Insert record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "create",
      "Incident",
      `This user created a new Incident for organization ${organizationId}`
    );

    return sendResponse(res, 200, "Record created successfully");
  }
};

/**Function to view all Incident */
export const viewAllIncident = async (req, res) => {
  const { id } = req.params;
  const condition = await whereCondition({
    table: "incident",
    page: req.query.page,
    all: req.query.all,
    orderBy: req.query.orderBy,
    pageSize: req.query.pageSize,
    filter: req.query.filter,
    id,
    user: req.user,
  });

  const searchTableName = [
    // "incident.location",
    "incident.description",
    "incident.current_impact",
    "incident.incident_title",
    "severity.name",
    "CONCAT(users.name , ' ' , users.surname)",
    "organization.name",
    "CONCAT(reporter_user.name , ' ' , reporter_user.surname)",
    // "CONCAT(internal_user.name , ' ' , internal_user.surname)",
  ];
  /** If value come with any search condition then search that word */
  let searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );

  /**Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "users",
      onCondition: "users.id = incident.created_by",
    },
    {
      type: "left",
      targetTable: "organization",
      onCondition: "organization.id = incident.organization",
    },
    {
      type: "left",
      targetTable: "department",
      onCondition: "department.id = incident.department",
    },
    {
      type: "left",
      targetTable: "users as reporter_user",
      onCondition: "reporter_user.id = incident.incident_reporting_by",
    },
    {
      type: "left",
      targetTable: "roles as reporter_role",
      onCondition: "reporter_user.role = reporter_role.id",
    },
    {
      type: "left",
      targetTable: "department as reporter_department",
      onCondition: "reporter_user.department = reporter_department.id",
    },
    {
      type: "left",
      targetTable: "permit_license_compliance",
      onCondition: "permit_license_compliance.id = incident.permit_license",
    },
    {
      type: "left",
      targetTable: "severity",
      onCondition: "severity.id = incident.initial_incident_severity",
    },
  ];

  const joinsRecord = await makeJoins(joins);

  /**Record of all alert */
  const incidentDataFetchQuery = `SELECT 
  permit_license_compliance.name as permit_license_title,
  permit_license_compliance.end_date AS permit_license_expiry_date,
    incident.*, 
    reporter_user.role,
    reporter_role.name as reporting_role_name,
    reporter_user.department,
    reporter_department.name as reporting_department,
    CONCAT(reporter_user.name , ' ' , reporter_user.surname) as incident_reporting_by_name,
    reporter_user.profile as incident_reporting_by_profile,
    severity.name as initial_incident_severity_name,
    CONCAT(users.name , ' ' , users.surname) as created_by_name,
    organization.name as organization_name,
    department.name as department_name
    FROM incident  
    ${joinsRecord} 
    where incident.deleted = 0 ${searchCondition} ${condition}`;

  //incident.incident_reference_no,
  // console.log(incidentDataFetchQuery)
  let [incidentDataFetch] = await db.query(incidentDataFetchQuery);
  // return console.log(incidentDataFetch);
  /**Count all Incident */
  let arr = [];
  incidentDataFetch = await decodeAndParseFields(incidentDataFetch);
  for (const obj of incidentDataFetch) {
    if (
      obj.incident_persons_involved &&
      Array.isArray(obj.incident_persons_involved)
    ) {
      for (let i = 0; i < obj.incident_persons_involved.length; i++) {
        const person = obj.incident_persons_involved[i];

        if (person.person_type === "Internal") {
          if (person.user_id) {
            const [fetch] = await db.query(
              `SELECT CONCAT(users.name, ' ', users.surname) AS user_name, 
                      roles.name AS role_name, 
                      department.name AS department_name 
               FROM users 
               LEFT JOIN roles ON users.role = roles.id 
               LEFT JOIN department ON users.department = department.id 
               WHERE users.id = ${person.user_id}`
            );

            let incidentRole = [];
            if (person.internal_incident_role) {
              [incidentRole] = await db.query(
                `SELECT name as internal_incident_role_name 
                 FROM incident_role 
                 WHERE id = ${person.internal_incident_role}`
              );
            }

            obj.incident_persons_involved[i] = {
              ...person,
              ...(fetch[0] || {}),
              ...(incidentRole[0] || {}),
            };
          }
        } else if (person.person_type === "External") {
          if (person.is_contractor === "1" && person.contractor_id) {
            const [contractorData] = await db.query(
              `SELECT contractor_name as contractor_name 
               FROM contractor_registration 
               WHERE id = ${person.contractor_id}`
            );

            const [incidentRole] = await db.query(
              `SELECT name as external_incident_role_name 
               FROM incident_role 
               WHERE id = ${person.external_incident_role}`
            );

            let projectData = {};
            if (person.project_id) {
              const [project] = await db.query(
                `SELECT id as project_id, project_title as project_name 
                 FROM project_registration 
                 WHERE id = ${person.project_id}`
              );
              projectData = project[0] || {};
            }

            obj.incident_persons_involved[i] = {
              ...person,
              ...(contractorData[0] || {}),
              ...(incidentRole[0] || {}),
              ...projectData,
            };
          } else {
            const [incidentRole] = await db.query(
              `SELECT name as external_incident_role_name 
               FROM incident_role 
               WHERE id = ${person.external_incident_role}`
            );

            obj.incident_persons_involved[i] = {
              ...person,
              ...(incidentRole[0] || {}),
            };
          }
        } else if (person.person_type === "Both") {
          let userDetails = {};
          if (person.user_id) {
            const [fetch] = await db.query(
              `SELECT CONCAT(users.name, ' ', users.surname) AS user_name, 
                      roles.name AS role_name, 
                      department.name AS department_name 
               FROM users 
               LEFT JOIN roles ON users.role = roles.id 
               LEFT JOIN department ON users.department = department.id 
               WHERE users.id = ${person.user_id}`
            );
            userDetails = fetch[0] || {};
          }

          let internalRoleDetails = {};
          if (person.internal_incident_role) {
            const [internalRole] = await db.query(
              `SELECT name as internal_incident_role_name 
               FROM incident_role 
               WHERE id = ${person.internal_incident_role}`
            );
            internalRoleDetails = internalRole[0] || {};
          }

          let externalDetails = {};
          let projectDetails = {};

          let externalRoleDetails = {};
          if (person.external_incident_role) {
            const [externalRole] = await db.query(
              `SELECT name as external_incident_role_name 
               FROM incident_role 
               WHERE id = ${person.external_incident_role}`
            );
            externalRoleDetails = externalRole[0] || {};
          }

          if (person.is_contractor === "1" && person.contractor_id) {
            const [contractorData] = await db.query(
              `SELECT contractor_name as contractor_name 
               FROM contractor_registration 
               WHERE id = ${person.contractor_id}`
            );
            externalDetails = contractorData[0] || {};

            if (person.project_id) {
              const [project] = await db.query(
                `SELECT id as project_id, project_title as project_name 
                 FROM project_registration 
                 WHERE id = ${person.project_id}`
              );
              projectDetails = project[0] || {};
            }
          }

          obj.incident_persons_involved[i] = {
            ...person,
            ...userDetails,
            ...internalRoleDetails,
            ...externalRoleDetails,
            ...externalDetails,
            ...projectDetails,
          };
        }
      }
    }
    const id = obj.id;
    if (obj.incident_category && obj.incident_category.length > 0) {
      const [incidentCategoryList] = await db.query(
        `SELECT name from incident_category WHERE id In (${obj.incident_category}) AND deleted = 0`
      );

      obj.incident_category_name = incidentCategoryList.map(
        (item) => item.name
      );
    }
    let usersList = [];
    if (obj.notification && obj.notification.length > 0) {
      [usersList] = await db.query(
        `SELECT users.id as user_id , CONCAT(users.name , ' ' , users.surname) as name , profile ,roles.id as role_id, roles.name as   role_name , 
        department.id as department_id, department.name as department_name from users
        LEFT JOIN roles ON roles.id = users.role 
        LEFT JOIN department ON department.id = users.department WHERE users.id In (${obj.notification}) AND users.deleted = "0"`
      );
    }

    if (obj.is_done == 1) {
      // get investigation id of this incident
      const [record] = await getRecord("investigation", "incident_id", obj.id);
      obj.investigation_id = record?.id;
    }
    // console.log(usersList, "usersList")
    obj.notification = usersList;

    /** check for all form submitted completely or not on a specific incident */

    const incidentCategoryQuery = `SELECT id, name , description FROM incident_category WHERE deleted = 0 AND id IN (${obj.incident_category})`;
    const [incidentCategoryList] = await db.query(incidentCategoryQuery);
    let result = [];
    let allFormSubmissionCheck = "Completed";
    let anyOneDraft = false;
    for (let i = 0; i < incidentCategoryList.length; i++) {
      const item = incidentCategoryList[i];
      if (incidentCategoryConstant[item.name]) {
        item.description = await decodeSingle_statement(item.description);
        const incidentCategoryFormList = incidentCategoryConstant[item.name];
        for (let j = 0; j < incidentCategoryFormList.length; j++) {
          const e = incidentCategoryFormList[j];
          /** Check the from is already added for this incident */
          let status = "Incomplete";
          let form_id = "";
          if (e.tableName) {
            const FormCheckQuery = `SELECT id, save_type FROM ${e.tableName} WHERE incident_id = ${id} AND deleted = 0 ORDER BY id DESC`;
            const [formRecord] = await db.query(FormCheckQuery);
            if (formRecord?.length > 0) {
              status = "Completed";
              form_id = formRecord[0].id;
            } else {
              form_id = "";
              allFormSubmissionCheck = "Incomplete";
            }
            // console.log(formRecord, "formRecord");
            if (formRecord[0]?.save_type == "draft") {
              status = "Draft";
              allFormSubmissionCheck = "Draft";
              anyOneDraft = true;
            }
          }

          result.push({
            ...item,
            title: e.name,
            status: status,
            form_id: form_id,
            incident_id: id,
          });
        }
      }
    }
    obj.all_form_submission = anyOneDraft ? "Draft" : allFormSubmissionCheck;
    if (
      obj.all_form_submission !== "Draft" &&
      obj.all_form_submission !== "Incomplete"
    ) {
      arr.push(obj);
    }
    // console.log(obj);
    const imageDataQuery = `SELECT incident_docs.id, incident_docs.doc_no, incident_docs.incident_id, document_creation.document_name as title, incident_docs.ddrm_id, repository.url as file, file_classification.id as file_classification, file_classification.name as file_classification_name FROM incident_docs LEFT JOIN file_classification ON incident_docs.file_classification = file_classification.id LEFT JOIN repository ON incident_docs.ddrm_id = repository.id LEFT JOIN document_creation ON document_creation.id = repository.document_creation_id WHERE incident_docs.incident_id = ${id} AND incident_docs.deleted = 0`;
    const [imageDataFetch] = await db.query(imageDataQuery);
    // Assuming imageDataFetch contains an array of objects with image data
    obj.photographs_incident = imageDataFetch.length
      ? imageDataFetch
      : [{ title: "", ddrm_id: "", file: "" }];

    if (obj?.incident_location?.length) {
      const [incidentLocation] = await db.query(
        `SELECT id,name from location WHERE id IN (${obj.incident_location}) AND deleted = 0`
      );
      obj.incident_location_name = incidentLocation;
    }
  }

  const totalRecord = await countQueryCondition(incidentDataFetchQuery);

  return res.status(200).json({
    data: incidentDataFetch,
    total: totalRecord,
    filtered: arr,
  });
};

/**Function to view incident Audit trails */
export const viewIncidentAuditTrail = async (req, res) => {
  const { id } = req.params;
  const pageSize = req.query.pageSize;
  const page = req.query.page;
  const all = req.query.all;

  const incidentRecord = await getRecord("incident", "id", id);
  if (incidentRecord.length === 0)
    return sendResponse(res, 404, "Report Not Found");
  const incident = incidentRecord[0];
  incident.incident_category = JSON.parse(incident?.incident_category || "[]");
  const incidentCategoryQuery = `SELECT id, name , description FROM incident_category WHERE deleted = 0 AND id IN (${incident.incident_category})`;
  const [incidentCategoryList] = await db.query(incidentCategoryQuery);
  let result = [];
  for (let i = 0; i < incidentCategoryList.length; i++) {
    const item = incidentCategoryList[i];
    if (incidentCategoryConstant[item.name]) {
      item.description = await decodeSingle_statement(item.description);
      const incidentCategoryFormList = incidentCategoryConstant[item.name];
      for (let j = 0; j < incidentCategoryFormList.length; j++) {
        const e = incidentCategoryFormList[j];
        /** Check the from is already added for this incident */
        let status = "Incomplete";
        let form_id = "";
        if (e.tableName) {
          const FormCheckQuery = `SELECT id, save_type FROM ${e.tableName} WHERE incident_id = ${id} AND deleted = 0 ORDER BY id DESC`;
          const [formRecord] = await db.query(FormCheckQuery);
          if (formRecord.length > 0) {
            status = "Completed";
            form_id = formRecord[0].id;
          } else {
            form_id = "";
          }
          // console.log(formRecord, "formRecord");
          if (formRecord[0]?.save_type == "draft") status = "Draft";
        }

        result.push({
          ...item,
          title: e.name,
          status: status,
          form_id: form_id,
          incident_id: id,
        });
      }
    }
  }
  const totalRecord = result.length;
  let recordList = result;
  /**Add manual Pagination */
  if (all === "false") {
    recordList = result.slice((page - 1) * pageSize, page * pageSize);
  }

  return sendResponse(res, 200, recordList, totalRecord);
};

/**Function to delete a specific Incident */
export const deleteIncident = async (req, res) => {
  const { id } = req.params;
  const { doc_id } = req.body; //Array will be passed of id's of images to delete
  if (doc_id) {
    for (const doc of doc_id) {
      const [fetchDocs] = await db.query(
        "SELECT image FROM incident_docs where id = ? AND incident_id = ?",
        [doc, id]
      );
      const fileName = fetchDocs[0].image;
      deleteFile(fileName);
      await db.query(
        "UPDATE incident_docs SET deleted = 1 WHERE id = ? AND incident_id = ?",
        [doc, id]
      );
    }
  }
  // for()
  const deleteRecordQuery = await deleteRecord("incident", id);
  if (deleteRecordQuery) {
    /**Insert record for activity log */
    await insertActivityLog(req.user.sessionid, "delete", "Incident", id);
    return sendResponse(
      res,
      200,
      "Record deleted successfully"
    );
  }
};

/**Function to view incident Investigation specific form filled or not*/
export const viewIncidentInvestigation = async (req, res) => {
  const { incidentId } = req.params;
  const pageSize = req.query.pageSize || 10;
  const page = req.query.page || 1;
  const all = req.query.all;

  const incidentRecord = await getRecord("incident", "id", incidentId);
  if (incidentRecord.length === 0)
    return sendResponse(res, 404, "Report Not Found");
  const incident = incidentRecord[0];
  incident.incident_category = JSON.parse(incident?.incident_category || "[]");
  // selected incident category list
  const selectedCategoryQuery = `SELECT id, name  FROM incident_category WHERE deleted = 0 AND id IN (${incident.incident_category})`;
  let [selectedCategoryList] = await db.query(selectedCategoryQuery);

  const incidentCategoryQuery = `SELECT MAX(id) as id, name  FROM incident_category WHERE deleted = 0 GROUP BY name`;
  const [incidentCategoryList] = await db.query(incidentCategoryQuery);
  let result = [];
  let incidentCategoryCheckObj = {};
  for (let i = 0; i < incidentCategoryList.length; i++) {
    const item = incidentCategoryList[i];
    if (incidentCategoryConstant[item.name]) {
      const incidentCategoryFormList = incidentCategoryConstant[item.name];
      for (let j = 0; j < incidentCategoryFormList.length; j++) {
        const e = incidentCategoryFormList[j];
        if (e.name && !incidentCategoryCheckObj[item.name]) {
          incidentCategoryCheckObj[item.name] = true;
          /** Check the form is already added for this incident */
          let status = "Incomplete";
          let form_id = "";
          let form_data = {};
          if (e.tableName) {
            const FormCheckQuery = `SELECT * FROM ${e.tableName} WHERE incident_id = ${incidentId} AND deleted = 0 ORDER BY id DESC`;
            let [formRecord] = await db.query(FormCheckQuery);
            formRecord = await decodeAndParseFields(formRecord);
            if (formRecord.length > 0) {
              status = "Completed";
              form_id = formRecord[0]?.id;
              console.log(e.key, "e.key");
              form_data[e.key] = formRecord[0][e.key];
              if (!e.key) {
                form_data = formRecord[0];
              }
              // added data for assets type form in another key if item.name is Assets
              if (item.name === "Assets") {
                const FormCheckQuery = `SELECT * FROM infrastructure_technical_form WHERE incident_id = ${incidentId} AND deleted = 0 ORDER BY id DESC`;
                let [formRecord] = await db.query(FormCheckQuery);
                formRecord = await decodeAndParseFields(formRecord);
                if (formRecord.length > 0) {
                  form_data.asset_type = formRecord[0]["asset_type"];
                }
              }
            } else {
              form_id = "";
              form_data = {};
            }
            if (formRecord[0]?.save_type == "draft") status = "Draft";
          }

          result.push({
            ...item,
            title: e.name,
            status: status,
            form_id: form_id,
            incident_id: incidentId,
            form_data: form_data,
          });
        }
      }
    }
  }

  result = result.map((e) => {
    const categorySelectedCheck = selectedCategoryList.find(
      (item) => item.name === e.name
    );
    if (categorySelectedCheck) {
      return e;
    } else {
      return {
        ...e,
        status: "Not Added",
      };
    }
  });
  const totalRecord = result.length;
  let recordList = result;
  /**Add manual Pagination */
  if (all === "false") {
    recordList = result.slice((page - 1) * pageSize, page * pageSize);
  }

  return sendResponse(res, 200, recordList, totalRecord);
};

// !not in use
// export const viewIncidentInvestigationNew = async (req, res) => {
//   const { incidentId } = req.params;
//   const incidentRecord = await getRecord("incident", "id", incidentId);
//   if (incidentRecord.length === 0) {
//     return sendResponse(res, 404, "Report Not Found");
//   }
//   const incident = incidentRecord[0];
//   incident.incident_category = JSON.parse(incident?.incident_category || "[]");
//   // selected incident category list
//   const selectedCategoryQuery = `SELECT id, name  FROM incident_category WHERE deleted = 0 AND id IN (${incident.incident_category})`;
//   let [selectedCategoryList] = await db.query(selectedCategoryQuery);

//   const incidentCategoryQuery = `SELECT MAX(id) as id, name  FROM incident_category WHERE deleted = 0 GROUP BY name`;
//   const [incidentCategoryList] = await db.query(incidentCategoryQuery);
//   let result = [];
//   let incidentCategoryCheckObj = {};
//   for (let i = 0; i < incidentCategoryList.length; i++) {
//     const item = incidentCategoryList[i];
//     if (incidentCategoryConstant[item.name]) {
//       const incidentCategoryFormList = incidentCategoryConstant[item.name];
//       for (let j = 0; j < incidentCategoryFormList.length; j++) {
//         const e = incidentCategoryFormList[j];
//         if (e.name && !incidentCategoryCheckObj[item.name]) {
//           incidentCategoryCheckObj[item.name] = true;
//           /** Check the form is already added for this incident */
//           let status = "Incomplete";
//           let form_id = "";
//           let form_data = {};
//           let assets_data = {};
//           if (e.tableName) {
//             const FormCheckQuery = `SELECT * FROM ${e.tableName} WHERE incident_id = ${incidentId} AND deleted = 0 ORDER BY id DESC`;
//             let [formRecord] = await db.query(FormCheckQuery);
//             formRecord = await decodeAndParseFields(formRecord);
//             if (formRecord.length > 0) {
//               status = "Completed";
//               form_id = formRecord[0]?.id;
//               form_data = formRecord[0];
//               // added data for assets type form in another key if item.name is Assets
//               if (item.name === "Assets") {
//                 const FormCheckQuery = `SELECT * FROM infrastructure_technical_form WHERE incident_id = ${incidentId} AND deleted = 0 ORDER BY id DESC`;
//                 let [formRecord] = await db.query(FormCheckQuery);
//                 formRecord = await decodeAndParseFields(formRecord);
//                 if (formRecord.length > 0) {
//                   assets_data = formRecord[0];
//                 }
//               }
//             } else {
//               form_id = "";
//               form_data = {};
//             }
//             if (formRecord[0]?.save_type == "draft") status = "Draft";
//           }

//           result.push({
//             ...item,
//             title: e.name,
//             status: status,
//             form_id: form_id,
//             incident_id: incidentId,
//             form_data: form_data,
//             assets_data: assets_data,
//           });
//         }
//       }
//     }
//   }

//   result = result.map((e) => {
//     const categorySelectedCheck = selectedCategoryList.find(
//       (item) => item.name === e.name
//     );
//     if (categorySelectedCheck) {
//       return e;
//     } else {
//       return {
//         ...e,
//         status: "Not Added",
//       };
//     }
//   });

//   return sendResponse(res, 200, result);
// };
