import db from "../db-config.js";
import {
  countQueryCondition,
  createQueryBuilder,
  decodeSingle_statement,
  deleteSettingRecord,
  encodeSingle_statement,
  getFilterConditions,
  getFirstCreatedAndAllOrganizationIds,
  getListingData,
  getRecord,
  insertActivityLog,
  makeJoins,
  searchConditionRecord,
  settingsUpdater,
  uniqueIdGenerator,
  whereCondition,
} from "../helper/general.js";
import { updateQueryBuilder } from "../helper/queryBuilder.js";
import { sendResponse } from "../helper/wrapper.js";
import License from "../sequelize/LicenseSchema.js";

/**Function to create and update License  */
export const createUpdatedLicense = async (req, res) => {
  const { name, description, organization, id } = req.body;
  const encodedDescription = await encodeSingle_statement(description);
  req.body.description = encodedDescription;
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  /**If id comes in body then it will update the query */
  const [checkNameWithOrganization] = await getRecord("license", "name", name);
  if (checkNameWithOrganization) {
    if (id && checkNameWithOrganization.id != id) {
      return sendResponse(res, 400, "License name already exist");
    } else if (!id) {
      return sendResponse(res, 400, "License name already exist");
    }
  }
  if (id) {
    /**Check that this organization have that particular name or not*/
    if (organization.length === 0) {
      return sendResponse(
        res,
        400,
        "Please Select at least one business Structure"
      );
    }

    /**update query */
    const { query, values } = updateQueryBuilder(License, req.body);
    await db.query(query, values);
    /**Update record for activity log */
    await insertActivityLog(req.user.sessionid, "update", "License", id);
    return sendResponse(res, 200, "Record updated successfully");
  } else {
    const orgData = await getFirstCreatedAndAllOrganizationIds();
    if (!orgData.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    req.body.unique_id = await uniqueIdGenerator(
      orgData.firstOrgId,
      req.body?.department || null,
      "License",
      "license",
      "unique_id",
      "unique_id"
    );
    // req.body.organization = organization.length > 0 ? organization : result.organizationIds;
    const { query, values } = createQueryBuilder(License, req.body);
    const result = await db.query(query, values);
    /**Insert record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "create",
      "License",
      result.insertId
    );
    return sendResponse(res, 200, "Record created successfully");
  }

  // const { id, name, description, organization } = req.body;
  // const encodedDescription = await encodeSingle_statement(description);
  // req.body.description = encodedDescription;

  // /**If id comes in body then it will update the query */
  // if (id) {
  //   req.body.updated_by = req.user.sessionid;
  //   if (organization.length === 0) {
  //     return sendResponse(
  //       res,
  //       400,
  //       "Please Select at least one business Structure"
  //     );
  //   }
  //   const result = await settingsUpdater(
  //     License,
  //     organization,
  //     req.body,
  //     req.user
  //   );
  //   if (!result) {
  //     return sendResponse(res, 404, "Record Not found");
  //   }
  //   /**Insert record for activity log */
  //   insertActivityLog(
  //     req.user.sessionid,
  //     "update",
  //     "License",
  //     `This user Update other License which id is ${id}`
  //   );

  //   return sendResponse(res, 200, "Record updated successfully");
  // } else {
  //   const insertPromises = organization.map(async (element) => {
  //     /** Check if this organization already has the particular name */
  //     const [checkNameWithOrganization] = await db.query(
  //       `SELECT name FROM license WHERE name = ? AND deleted = '0' AND organization = ?`,
  //       [name, element]
  //     );

  //     /** If record not found for that name with particular organization, insert the record */
  //     if (checkNameWithOrganization.length === 0) {
  //       /** Insert License details */
  //       req.body.created_by = req.user.sessionid;
  //       req.body.organization = element;

  //       const unique_id = await uniqueIdGenerator(
  //         element,
  //         req?.body?.department || null,
  //         "License",
  //         "license",
  //         "unique_id",
  //         "unique_id"
  //       );

  //       // return console.log(unique_id);
  //       req.body.unique_id = unique_id;

  //       const { query, values } = createQueryBuilder(License, {
  //        ...req.body,
  //        organization:element
  //       });
  //       await db.query(query, values);

  //       /** Insert record for activity log */
  //       await insertActivityLog(
  //         req.user.sessionid,
  //         "create",
  //         "License",
  //         `This user created a new other Skills named ${name} for organization ${element}`
  //       );
  //     }
  //   });

  //   await Promise.all(insertPromises);

  //   return sendResponse(res, 200, "Record created successfully");
  // }
};

/**Function to view all License */
export const viewAllLicense = async (req, res) => {
  let { organizationCondition, condition } = await getFilterConditions(
    req,
    db,
    "license"
  );
  /** If value come with any search condition then search that word */
  const searchTableName = [
    "license.name",
    "license.description",
    "createdUser.name",
  ];
  /** If value come with any search condition then search that word */
  let searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );
  /**Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "users as createdUser",
      onCondition: "createdUser.id = license.created_by",
    },
  ];
  const joinsRecord = await makeJoins(joins);
  /**Record of all Skill */
  let licenseQuery = `SELECT 
  license.*, 
  license.organization AS organizations, 
  createdUser.name AS created_by, 
  createdUser.surname AS created_by_surname, 
  createdUser.id AS created_by_id, 
  createdUser.profile AS created_by_profile
FROM license
${joinsRecord} 
WHERE license.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;

  // console.log(skillQuery, "skillQuery");
  let [license] = await db.query(licenseQuery);
  license = await getListingData(license);
  /**Count all organization */
  const totalRecord = await countQueryCondition(licenseQuery);
  return sendResponse(res, 200, license, totalRecord);

  // const { id } = req.params;
  // const condition = await whereCondition({
  //   table: "license",
  //   page: req.query.page,
  //   all: req.query.all,
  //   pageSize: req.query.pageSize,
  //   id,
  //   grouped: req.query.grouped,
  //   user: req.user,
  // });

  // const searchTableName = [
  //   "license.name",
  //   "license.description",
  //   "createdUser.name",
  // ];
  // /** If value come with any search condition then search that word */
  // let searchCondition = await searchConditionRecord(
  //   req.query.search,
  //   searchTableName
  // );

  // /** If value come with any search condition then search that word */

  // /**Make Joins according to tables */
  // const joins = [
  //   {
  //     type: "left",
  //     targetTable: "users as createdUser",
  //     onCondition: "createdUser.id = license.created_by",
  //   },
  // ];
  // const joinsRecord = await makeJoins(joins);

  // /**Record of all alert */
  // const licenseDataFetchQuery = `SELECT license.* ,createdUser.name as created_by , createdUser.surname as created_by_surname , createdUser.id as created_by_id, createdUser.profile as created_by_profile , organization.name as organization_name
  //   FROM license
  //   ${joinsRecord}
  //   where license.deleted = 0 ${searchCondition} ${condition}`;

  // const [licenseDataFetch] = await db.query(licenseDataFetchQuery);
  // for (const license of licenseDataFetch) {
  //   license.description = await decodeSingle_statement(license.description);
  //   if (req.query.grouped == "true") {
  //     const [organizations] = await db.query(
  //       `SELECT organization FROM license WHERE deleted = 0 AND name = ?`,
  //       [license.name]
  //     );
  //     const arr = organizations.map((item) => item.organization);
  //     license.organizations = arr;
  //   }
  // }

  // /**Count all license */
  // const totalRecord = await countQueryCondition(licenseDataFetchQuery);

  // return sendResponse(res, 200, licenseDataFetch, totalRecord);
};

/**Function to delete a specific License */
export const deleteLicense = async (req, res) => {
  const { id } = req.params;
  const deleteRecordQuery = await deleteSettingRecord("license", id);
  if (deleteRecordQuery) {
    /**Insert record for activity log */
    await insertActivityLog(req.user.sessionid, "delete", "license", id);
    return sendResponse(res, 200, "Record deleted successfully");
  }
};
