import {
  countQueryCondition,
  decodeAndParseFields,
  decodeSingle_statement,
  deleteRecord,
  encodeSingle_statement,
  getOrganizationAccordingToDepartment,
  insertActivityLog,
  makeJoins,
  searchConditionRecord,
  updateQueryBuilder,
  whereCondition,
} from "../helper/general.js";
import db from "../db-config.js";
import { createQueryBuilder } from "../helper/queryBuilder.js";
import { sendResponse } from "../helper/wrapper.js";
import NonComplianceTechnicalForm from "../sequelize/NonComplianceTechnicalFormSchema.js";
import { uploadToDDRM } from "../helper/ddrmUploader.js";

/**Function to create Safety Incident Form  */
export const createNonComplianceStopCertificateForm = async (req, res) => {
  req.body = (await decodeAndParseFields([req.body]))[0];

  const { id } = req.body;
  const sessionId = req.user.sessionid;
  let organizationId = req.body.organization;
  const {
    department,
    conditions_of_stop_certificate,
    requirements_contravened,
    non_conformance_description,
    compliance_to_mitigation,
    sidebarId = 189,
  } = req.body;
  console.log(
    "req.body: ",
    req.body.quality_incident_details[0]?.customer_complaints_details
  );
  console.log(req.files);
  // return;
  if (department) {
    const recordAccordingToOrganization =
      await getOrganizationAccordingToDepartment(department);
    organizationId = recordAccordingToOrganization[0]?.organization;
    if (organizationId) {
      req.body.organization = organizationId;
    }
  }

  for (let i = 0; i < req.body.quality_incident_details.length; i++) {
    const detail = req.body.quality_incident_details[i];
    if (detail.quality_incident_type === "Customer Complaints") {
      const file =
        req.files &&
        req.files[
          `quality_incident_details[${i}].customer_complaints_details[file]`
        ];

      // let ddrm_id = "";
      // if (typeof file !== "string" && typeof file !== "undefined" && file !== null) {
      //   ddrm_id = await uploadToDDRM(sidebarId, file, req);

      //   const old_ddrm_id = req.body[`quality_incident_details[${i}].customer_complaints_details[ddrm_id]`];
      //   if (old_ddrm_id) {
      //     await updateArchiveRepoDoc(old_ddrm_id);
      //   }
      // } else {
      //   ddrm_id = req.body[`quality_incident_details[${i}].customer_complaints_details[ddrm_id]`];
      // }

      // req.body.quality_incident_details[i].customer_complaints_details.ddrm_id = ddrm_id;
    }
  }

  req.body.compliance_to_mitigation = await encodeSingle_statement(
    compliance_to_mitigation
  );
  req.body.non_conformance_description = await encodeSingle_statement(
    non_conformance_description
  );
  req.body.requirements_contravened = await encodeSingle_statement(
    requirements_contravened
  );
  req.body.conditions_of_stop_certificate = await encodeSingle_statement(
    conditions_of_stop_certificate
  );

  req.body.created_by = sessionId;
  const { query, values } = id
    ? updateQueryBuilder(NonComplianceTechnicalForm, req.body)
    : createQueryBuilder(NonComplianceTechnicalForm, req.body);
  const [createNonComplianceStopCertificateForm] = await db.query(
    query,
    values
  );
  if (!id && createNonComplianceStopCertificateForm.insertId === 0) {
    return sendResponse(res, 404, "Cannot create record");
  }

  await insertActivityLog(
    req.user.sessionid,
    "create",
    "Non Compliance Technical ",
    `This user created a new Non Compliance Technical  Form Record for organization ${organizationId}`
  );

  return sendResponse(res, 200, "Record created successfully");
};

export const getNonComplianceStopCertificateForm = async (req, res) => {
  const { type } = req.query;
  const { id } = req.params;
  const condition = await whereCondition({
    table: "non_compliance_technical_form",
    page: req.query.page,
    all: req.query.all,
    pageSize: req.query.pageSize,
    filter: req.query.filter,
    id,
    grouped: req.query.grouped,
    user: req.user,
    columnName: type,
  });
  const searchTableName = [
    "non_compliance_technical_form.stop_certificate_id",
    "non_compliance_technical_form.ncr_id",
    "non_compliance_technical_form.recipient_full_name",
    "non_compliance_technical_form.recipient_role_name",
    "non_compliance_technical_form.recipient_contact_number",
    "non_compliance_technical_form.employee_number",
    "non_compliance_technical_form.acceptance",
    "non_compliance_technical_form.specify",
    "non_compliance_technical_form.issuer_full_name",
    "non_compliance_technical_form.issuer_role_name",
    "non_compliance_technical_form.issuer_contact_number",
    "non_compliance_technical_form.verifier_full_name",
    "non_compliance_technical_form.verifier_role_name",
    "non_compliance_technical_form.verifier_contact_number",
    "non_compliance_technical_form.signature_original_issuer",
    "non_compliance_technical_form.signature_accepting_lift",
    "non_compliance_technical_form.non_conformance_description",
    "non_compliance_technical_form.requirements_contravened",
    "non_compliance_technical_form.conditions_of_stop_certificate",
    "non_compliance_technical_form.compliance_to_mitigation",
  ];

  const searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );

  const joins = [
    {
      type: "left",
      targetTable: "users",
      onCondition: "users.id = non_compliance_technical_form.created_by",
    },
    {
      type: "left",
      targetTable: "organization",
      onCondition:
        "organization.id = non_compliance_technical_form.organization",
    },
    {
      type: "left",
      targetTable: "department",
      onCondition: "department.id = non_compliance_technical_form.department",
    },
  ];
  const joinCondition = await makeJoins(joins);
  const nonComplianceTechnicalFormQuery = `SELECT non_compliance_technical_form.* , organization.name as organization_name ,department.name as department_name , users.name as created_by_name , users.surname as created_by_surname  , users.profile as created_by_profile FROM non_compliance_technical_form ${joinCondition} WHERE non_compliance_technical_form.deleted = 0 ${condition} ${searchCondition}`;
  const totalRecord = await countQueryCondition(
    nonComplianceTechnicalFormQuery
  );

  let [nonComplianceTechnicalForm] = await db.query(
    nonComplianceTechnicalFormQuery
  );
  // console.log(nonComplianceTechnicalForm);
  nonComplianceTechnicalForm = await decodeAndParseFields(
    nonComplianceTechnicalForm
  );

  const quality_incident_details =
    nonComplianceTechnicalForm[0].quality_incident_details;
  for (let qualityIncident of quality_incident_details) {
    if (qualityIncident.quality_incident_type === "Customer Complaints") {
      const customerComplaints = qualityIncident.customer_complaints_details;
      if (customerComplaints?.ddrm_id) {
        console.log(
          "customerComplaints?.ddrm_id: ",
          customerComplaints?.ddrm_id
        );
        const [file] = await db.query(
          `SELECT repository.url as file FROM repository WHERE id = ${customerComplaints.ddrm_id}`
        );
        customerComplaints.file = file.length ? file[0].file : null;
      }
    }
  }
  // console.log(nonComplianceTechnicalForm);
  return sendResponse(res, 200, nonComplianceTechnicalForm, totalRecord);
};

export const deleteNonComplianceStopCertificateForm = async (req, res) => {
  const { id } = req.params;
  const deleteForm = await deleteRecord("non_compliance_technical_form", id);
  if (deleteForm) {
    await insertActivityLog(
      req.user.sessionid,
      "delete",
      "Non Compliance Technical Form",
      `This user deleted a new Non Compliance Technical Form Record for organization ${id}`
    );
    return sendResponse(res, 200, "Record deleted successfully");
  }
  return sendResponse(res, 404, "Cannot delete record");
};
