import db from "../db-config.js";
import { sendResponse } from "../helper/wrapper.js";
import {
  insertActivityLog,
  searchConditionRecord,
  makeJoins,
  whereCondition,
  countQueryCondition,
  settingsUpdater,
  deleteSettingRecord,
  encodeSingle_statement,
  decodeSingle_statement,
  uniqueIdGenerator,
  getFirstCreatedAndAllOrganizationIds,
  getFilterConditions,
  getListingData,
  updateQueryBuilder,
  createQueryBuilder,
  encodeAndStringifyFields,
} from "../helper/general.js";
import Race from "../sequelize/RaceSchema.js";

/** Function to create or update Race */
export const createUpdateRace = async (req, res) => {
  const { id, organization } = req.body;

  if (id && organization.length === 0) {
    return sendResponse(res, 404, "Please Select at least one business Structure");
  }

  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();

    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "Race",
      "race",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization = organization.length > 0 ? organization : result.organizationIds;
  }

  let status = id ? "Updated" : "Created";
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  req.body = await encodeAndStringifyFields(req.body);
  const { query, values } = id ? updateQueryBuilder(Race, req.body) : createQueryBuilder(Race, req.body);
  const [result] = await db.query(query, values);
  await insertActivityLog(req.user.sessionid, status, "Race", id ? id : result.insertId);
  return sendResponse(res, 200, `Record ${status} Successfully`);
};

/** Function to view all or single Race */
export const viewRace = async (req, res) => {
  let { organizationCondition, condition } = await getFilterConditions(req, db, "race");

  const searchFields = ["race.name", "race.description", "users.name"];
  let searchCondition = await searchConditionRecord(req.query.search, searchFields);
  const joins = [{ type: "left", targetTable: "users", onCondition: "users.id = race.created_by" }];
  const joinsRecord = await makeJoins(joins);

  const fetchQuery = `SELECT race.*, CONCAT(users.name, ' ', users.surname) AS created_by, race.organization AS organizations FROM race ${joinsRecord} WHERE race.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;
  let [records] = await db.query(fetchQuery);

  records = await getListingData(records);

  const totalRecord = await countQueryCondition(fetchQuery);
  return sendResponse(res, 200, records, totalRecord);
};

/** Function to delete Race */
export const deleteRace = async (req, res) => {
  const { id } = req.params;
  const deleteRecord = await deleteSettingRecord("race", id);
  if (deleteRecord) {
    await insertActivityLog(req.user.sessionid, "delete", "Race", id);
    return sendResponse(res, 200, "Record deleted successfully");
  } else {
    return sendResponse(res, 404, "Record not found");
  }
};
