import db from "../db-config.js";
import { sendResponse } from "../helper/wrapper.js";
import {
  insertActivityLog,
  searchConditionRecord,
  makeJoins,
  whereCondition,
  countQueryCondition,
  settingsUpdater,
  deleteSettingRecord,
  encodeSingle_statement,
  decodeSingle_statement,
  uniqueIdGenerator,
  getFirstCreatedAndAllOrganizationIds,
  getRecord,
  getListingData,
  getFilterConditions,
} from "../helper/general.js";
import Severity from "../sequelize/SeveritySchema.js";
import {
  createQueryBuilder,
  updateQueryBuilder,
} from "../helper/queryBuilder.js";

/** Function to create or update Severity */
export const createUpdateSeverity = async (req, res) => {
  let { id, name, description, department, organization } = req.body;
  name = name.trim();
  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();

    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "Severity",
      "severity",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization =
      organization.length > 0 ? organization : result.organizationIds;
  }
  const encodedDescription = await encodeSingle_statement(description);
  req.body.description = encodedDescription;
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  /**If id comes in body then it will update the query */
  const [checkNameWithOrganization] = await getRecord("severity", "name", name);
  if (checkNameWithOrganization) {
    if (id && checkNameWithOrganization.id != id) {
      return sendResponse(res, 400, "Severity name already exist");
    } else if (!id) {
      return sendResponse(res, 400, "Severity name name  already exist");
    }
  }
  if (id) {
    /**Check that this organization have that particular name or not*/
    if (organization.length === 0) {
      return sendResponse(
        res,
        400,
        "Please Select at least one business Structure"
      );
    }

    /**update query */
    const { query, values } = updateQueryBuilder(Severity, req.body);
    await db.query(query, values);
    /**Update record for activity log */
    await insertActivityLog(req.user.sessionid, "update", "Severity", id);
    return sendResponse(res, 200, "Record updated successfully");
  } else {
    const { query, values } = createQueryBuilder(Severity, req.body);
    const result = await db.query(query, values);
    /**Insert record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "create",
      "Severity",
      result.insertId
    );
    return sendResponse(res, 200, "Record created successfully");
  }

  // const encodedDescription = await encodeSingle_statement(description);

  // if (id) {
  //   const result = await settingsUpdater(Severity, req.body.organization, req.body, req.user);
  //   if (!result) {
  //     return sendResponse(res, 404, "No data found");
  //   }
  //   await insertActivityLog(req.user.sessionid, "update", "Severity", `This user updated Severity with id: ${id}`);
  //   return sendResponse(res, 200, "Record updated successfully");
  // } else {
  //   const unique_id = await uniqueIdGenerator(
  //     req.body.organization,
  //     department,
  //     "IMS",
  //     "severity",
  //     "unique_id",
  //     "unique_id"
  //   );
  //   req.body.unique_id = unique_id;
  //   const insertPromises = req.body.organization.map(async (org) => {
  //     const [checkName] = await db.query(
  //       `SELECT name FROM severity WHERE name = ? AND deleted = 0 AND organization = ?`,
  //       [name, org]
  //     );
  //     if (checkName.length === 0) {
  //       await db.query(`INSERT INTO severity (name, description, created_by, organization, unique_id) VALUES (?, ?, ?, ?, ?)`, [
  //         name,
  //         encodedDescription,
  //         req.user.sessionid,
  //         org,
  //         req.body.unique_id,
  //       ]);
  //       await insertActivityLog(
  //         req.user.sessionid,
  //         "create",
  //         "Severity",
  //         `This user created a new Severity '${name}' for organization ${org}`
  //       );
  //     }
  //   });
  //   await Promise.all(insertPromises);
  //   return sendResponse(res, 200, "Record created successfully");
  // }
};

/** Function to view all or single Severity */
export const viewSeverity = async (req, res) => {
  
  let { organizationCondition, condition } = await getFilterConditions(
    req,
    db,
    "severity"
  );
  /** If value come with any search condition then search that word */
  const searchTableName = [
    "severity.name",
    "severity.description",
    "createdUser.name",
  ];
  /** If value come with any search condition then search that word */
  let searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );
  /**Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "users as createdUser",
      onCondition: "createdUser.id = severity.created_by",
    },
  ];
  const joinsRecord = await makeJoins(joins);
  /**Record of all Skill */
  let severityQuery = `SELECT 
  severity.*, 
  severity.organization AS organizations, 
  createdUser.name AS created_by, 
  createdUser.surname AS created_by_surname, 
  createdUser.id AS created_by_id, 
  createdUser.profile AS created_by_profile
FROM severity
${joinsRecord} 
WHERE severity.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;

  // console.log(skillQuery, "skillQuery");
  let [severity] = await db.query(severityQuery);
  severity = await getListingData(severity);
  /**Count all organization */
  const totalRecord = await countQueryCondition(severityQuery);
  return sendResponse(res, 200, severity, totalRecord);




  
  
  
  
  
  
  
  
  
  // const { id } = req.params;
  // const condition = await whereCondition({
  //   table: "severity",
  //   page: req.query.page,
  //   all: req.query.all,
  //   pageSize: req.query.pageSize,
  //   filter: req.query.filter,
  //   id,
  //   user: req.user,
  //   grouped: req.query.grouped,
  // });

  // const searchFields = [
  //   "severity.name",
  //   "severity.description",
  //   "users.name",
  //   "organization.name",
  // ];
  // let searchCondition = await searchConditionRecord(
  //   req.query.search,
  //   searchFields
  // );
  // const joins = [
  //   {
  //     type: "left",
  //     targetTable: "users",
  //     onCondition: "users.id = severity.created_by",
  //   },
  //   {
  //     type: "left",
  //     targetTable: "organization",
  //     onCondition: "organization.id = severity.organization",
  //   },
  // ];
  // const joinsRecord = await makeJoins(joins);

  // let fetchQuery = `SELECT severity.*, CONCAT(users.name, ' ', users.surname) AS created_by, organization.name AS organization_name FROM severity ${joinsRecord} WHERE severity.deleted = 0 ${searchCondition} ${condition}`;
  // fetchQuery = fetchQuery.replace(
  //   /ORDER BY severity\.id DESC\s*/i, // Match with optional space or semicolon
  //   "ORDER BY CAST(SUBSTRING_INDEX(severity.name, ' ', 2) AS UNSIGNED)"
  // );

  // let [records] = await db.query(fetchQuery);

  // for (const record of records) {
  //   record.description = await decodeSingle_statement(record.description);
  //   if (req.query.grouped == "true") {
  //     const [organizations] = await db.query(
  //       `SELECT organization FROM severity WHERE deleted = 0 AND name = ?`,
  //       [record.name]
  //     );
  //     const arr = organizations.map((item) => item.organization);
  //     record.organizations = arr;
  //   }
  // }

  // const totalRecord = await countQueryCondition(fetchQuery);
  // return sendResponse(res, 200, records, totalRecord);
};

/** Function to delete Severity */
export const deleteSeverity = async (req, res) => {
  const { id } = req.params;
  const deleteRecord = await deleteSettingRecord("severity", id);
  if (deleteRecord) {
    await insertActivityLog(req.user.sessionid, "delete", "Severity", id);
    return sendResponse(res, 200, "Record deleted successfully");
  } else {
    return sendResponse(res, 404, "Record not found");
  }
};
