import crypto from "crypto";

// Encryption and decryption helper functions
const ENCRYPTION_KEY = "your_secret_key"; // Use a secure key
const ALGORITHM = "aes-256-cbc"; // Encryption algorithm

function encrypt(text) {
  const iv = crypto.randomBytes(16);
  const cipher = crypto.createCipheriv(
    ALGORITHM,
    Buffer.from(ENCRYPTION_KEY),
    iv
  );
  let encrypted = cipher.update(text, "utf8", "hex");
  encrypted += cipher.final("hex");
  return iv.toString("hex") + ":" + encrypted;
}

function decrypt(text) {
  const [ivHex, encryptedText] = text.split(":");
  const iv = Buffer.from(ivHex, "hex");
  const decipher = crypto.createDecipheriv(
    ALGORITHM,
    Buffer.from(ENCRYPTION_KEY),
    iv
  );
  let decrypted = decipher.update(encryptedText, "hex", "utf8");
  decrypted += decipher.final("utf8");
  return decrypted;
}

// Middleware to encrypt incoming request data
export function encryptFields(fieldsToEncrypt) {
  return (req, res, next) => {
    if (req.body) {
      fieldsToEncrypt.forEach((field) => {
        if (req.body[field]) {
          req.body[field] = encrypt(req.body[field]);
        }
      });
    }
    next(); // Pass the request to the next middleware/controller
  };
}

// Middleware to decrypt data before sending response
export function decryptFields(fieldsToDecrypt) {
  return (req, res, next) => {
    if (res.locals.data) {
      // Assuming decrypted data is stored in res.locals.data
      fieldsToDecrypt.forEach((field) => {
        if (res.locals.data[field]) {
          res.locals.data[field] = decrypt(res.locals.data[field]);
        }
      });
    }
    next(); // Pass the response to the next middleware or directly send it
  };
}
