import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { createUpdateComplaintCategory, deleteComplaintCategory, viewComplaintCategory } from "../controller/complaintCategoryController.js";

/**
 * @swagger
 * tags:
 *   name:  complaint category
 *   description: API operations for managing  complaint category
 */
const complaintCategoryRoutes = Router();

/**
 * @swagger
 * /api/complaintCategory/create-update-complaint-category:
 *   post:
 *     summary: Create or update a  complaint category
 *     tags: [ complaint category]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
complaintCategoryRoutes.post(
  "/create-update-complaint-category",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 417 , "complaint_category")(req, res, next);
  },
  controllerWrapper(createUpdateComplaintCategory)
);

/**
 * @swagger
 * /api/complaintCategory/get-complaint-category:
 *   get:
 *     summary: Get all records of  complaint category
 *     tags: [ complaint category]
 */
complaintCategoryRoutes.get(
  "/get-complaint-category",
  verifyToken,
  sideBarPermissionCheck("view", 417, "complaint_category"),
  controllerWrapper(viewComplaintCategory)
);

/**
 * @swagger
 * /api/complaintCategory/get-complaint-category/{id}:
 *   get:
 *     summary: Get a specific record of  complaint category
 *     tags: [ complaint category]
 */
complaintCategoryRoutes.get(
  "/get-complaint-category/:id",
  verifyToken,
  sideBarPermissionCheck("view", 417, "complaint_category"),
  controllerWrapper(viewComplaintCategory)
);

/**
 * @swagger
 * /api/complaintCategory/delete-complaint-category/{id}:
 *   delete:
 *     summary: Delete a specific record of  complaint category
 *     tags: [ complaint category]
 */
complaintCategoryRoutes.delete(
  "/delete-complaint-category/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 417, "complaint_category"),
  controllerWrapper(deleteComplaintCategory)
);

export default complaintCategoryRoutes;