// Import necessary modules
import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import {
  createUpdatedContractorIncident,
  deleteContractorIncident,
  viewAllContractorIncident,
} from "../controller/contractorIncidentController.js";
import { controllerWrapper } from "../helper/wrapper.js";

/**
 * @swagger
 * tags:
 *   name: Contractor Incident
 *   description: API operations for managing all MeetingType
 */
const contractorIncidentRoutes = Router();

/**
 * @swagger
 * api/contractorIncident/create-update-contractor-incident:
 *   post:
 *     summary: Create or update a Contractor Incident
 *     tags: [Contractor Incident]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example:
 *             {
 *               id: 1,
 *             }
 */

contractorIncidentRoutes.post(
  "/create-update-contractor-incident",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(
      req.body.id ? "edit" : "create",
      273,
      "contractor_incident"
    )(req, res, next);
  },
  controllerWrapper(createUpdatedContractorIncident)
);

/**
 * @swagger
 * api/contractorIncident/get-contractor-incident:
 *   get:
 *     summary: Get all list of Contractor Incident
 *     tags: [Contractor Incident]
 */
contractorIncidentRoutes.get(
  "/get-contractor-incident",
  verifyToken,
  sideBarPermissionCheck("view", 273, "contractor_incident"),
  controllerWrapper(viewAllContractorIncident)
);

/**
 * @swagger
 * api/contractorIncident/get-contractor-incident/{id}:
 *   get:
 *     summary: Get a specific record of Contractor Incident
 *     tags: [Contractor Incident]
 */
contractorIncidentRoutes.get(
  "/get-contractor-incident/:id",
  verifyToken,
  sideBarPermissionCheck("view", 273, "contractor_incident"),
  controllerWrapper(viewAllContractorIncident)
);

/**
 * @swagger
 * api/contractorIncident/delete-contractor-incident/{id}:
 *   delete:
 *     summary: delete a specific record of contractor Incident
 *     tags: [Contractor Incident]
 */
contractorIncidentRoutes.delete(
  "/delete-contractor-incident/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 273, "contractor_incident"),
  controllerWrapper(deleteContractorIncident)
);

export default contractorIncidentRoutes;

// /**
//  * @swagger
//  * get-contractor-incident-audit-trial/:id:
//  *   get:
//  *     summary: Get all list of Contractor Incident
//  *     tags: [Contractor Incident]
//  */
// contractorIncidentRoutes.get(
//   "/get-contractor-incident-audit-trial/:id",
//   verifyToken,
//   sideBarPermissionCheck("view", 273, "contractor_incident"),
//   controllerWrapper(viewContractorIncidentAuditTrail)
// );
