import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { createUpdateFeedbackContext, deleteFeedbackContext, viewFeedbackContext } from "../controller/feedbackContextController.js";

/**
 * @swagger
 * tags:
 *   name:  feedback context
 *   description: API operations for managing  feedback context
 */
const feedbackContextRoutes = Router();

/**
 * @swagger
 * /api/feedbackContext/create-update-feedback-context:
 *   post:
 *     summary: Create or update a  feedback context
 *     tags: [ feedback context]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
feedbackContextRoutes.post(
  "/create-update-feedback-context",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 410 , "feedback_context")(req, res, next);
  },
  controllerWrapper(createUpdateFeedbackContext)
);

/**
 * @swagger
 * /api/feedbackContext/get-feedback-context:
 *   get:
 *     summary: Get all records of  feedback context
 *     tags: [ feedback context]
 */
feedbackContextRoutes.get(
  "/get-feedback-context",
  verifyToken,
  sideBarPermissionCheck("view", 410, "feedback_context"),
  controllerWrapper(viewFeedbackContext)
);

/**
 * @swagger
 * /api/feedbackContext/get-feedback-context/{id}:
 *   get:
 *     summary: Get a specific record of  feedback context
 *     tags: [ feedback context]
 */
feedbackContextRoutes.get(
  "/get-feedback-context/:id",
  verifyToken,
  sideBarPermissionCheck("view", 410, "feedback_context"),
  controllerWrapper(viewFeedbackContext)
);

/**
 * @swagger
 * /api/feedbackContext/delete-feedback-context/{id}:
 *   delete:
 *     summary: Delete a specific record of  feedback context
 *     tags: [ feedback context]
 */
feedbackContextRoutes.delete(
  "/delete-feedback-context/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 410, "feedback_context"),
  controllerWrapper(deleteFeedbackContext)
);

export default feedbackContextRoutes;