import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { createUpdateMainProcess, deleteMainProcess, viewMainProcess } from "../controller/mainProcessController.js";

/**
 * @swagger
 * tags:
 *   name:  main process
 *   description: API operations for managing  main process
 */
const mainProcessRoutes = Router();

/**
 * @swagger
 * /api/mainProcess/create-update-main-process:
 *   post:
 *     summary: Create or update a  main process
 *     tags: [ main process]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
mainProcessRoutes.post(
  "/create-update-main-process",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 405 , "main_process")(req, res, next);
  },
  controllerWrapper(createUpdateMainProcess)
);

/**
 * @swagger
 * /api/mainProcess/get-main-process:
 *   get:
 *     summary: Get all records of  main process
 *     tags: [ main process]
 */
mainProcessRoutes.get(
  "/get-main-process",
  verifyToken,
  sideBarPermissionCheck("view", 405, "main_process"),
  controllerWrapper(viewMainProcess)
);

/**
 * @swagger
 * /api/mainProcess/get-main-process/{id}:
 *   get:
 *     summary: Get a specific record of  main process
 *     tags: [ main process]
 */
mainProcessRoutes.get(
  "/get-main-process/:id",
  verifyToken,
  sideBarPermissionCheck("view", 405, "main_process"),
  controllerWrapper(viewMainProcess)
);

/**
 * @swagger
 * /api/mainProcess/delete-main-process/{id}:
 *   delete:
 *     summary: Delete a specific record of  main process
 *     tags: [ main process]
 */
mainProcessRoutes.delete(
  "/delete-main-process/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 405, "main_process"),
  controllerWrapper(deleteMainProcess)
);

export default mainProcessRoutes;