import { Router } from "express";
import { controllerWrapper } from "../helper/wrapper.js";
import { getNewLocation, getStructuredNewLocation } from "../controller/newLocationController.js";
import { verifyToken } from "../helper/tokenVerify.js";

/**
 * @swagger
 * tags:
 *   name:  New Location
 *   description: API operations for managing new location
 */
const newLocationRoutes = Router();

/**
 * @swagger
 * /api/newLocation/get-new-location:
 *   get:
 *     summary: Get all records of New Location
 *     tags: [ New Location ]
 */
newLocationRoutes.get("/get-new-location/:id?", verifyToken, controllerWrapper(getNewLocation));

/**
 * @swagger
 * /api/newLocation/get-structured-new-location:
 *   get:
 *     summary: Get all records of New Location
 *     tags: [ New Location ]
 */
newLocationRoutes.get("/get-structured-new-location/:id?", verifyToken, controllerWrapper(getStructuredNewLocation));

export default newLocationRoutes;
