import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { createUpdateOccupationalDiseaseType, deleteOccupationalDiseaseType, viewOccupationalDiseaseType } from "../controller/occupationalDiseaseTypeController.js";

/**
 * @swagger
 * tags:
 *   name:  occupational disease type
 *   description: API operations for managing  occupational disease type
 */
const occupationalDiseaseTypeRoutes = Router();

/**
 * @swagger
 * /api/occupationalDiseaseType/create-update-occupational-disease-type:
 *   post:
 *     summary: Create or update a  occupational disease type
 *     tags: [ occupational disease type]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
occupationalDiseaseTypeRoutes.post(
  "/create-update-occupational-disease-type",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 13 , "occupational_disease_type")(req, res, next);
  },
  controllerWrapper(createUpdateOccupationalDiseaseType)
);

/**
 * @swagger
 * /api/occupationalDiseaseType/get-occupational-disease-type:
 *   get:
 *     summary: Get all records of  occupational disease type
 *     tags: [ occupational disease type]
 */
occupationalDiseaseTypeRoutes.get(
  "/get-occupational-disease-type",
  verifyToken,
  sideBarPermissionCheck("view", 13, "occupational_disease_type"),
  controllerWrapper(viewOccupationalDiseaseType)
);

/**
 * @swagger
 * /api/occupationalDiseaseType/get-occupational-disease-type/{id}:
 *   get:
 *     summary: Get a specific record of  occupational disease type
 *     tags: [ occupational disease type]
 */
occupationalDiseaseTypeRoutes.get(
  "/get-occupational-disease-type/:id",
  verifyToken,
  sideBarPermissionCheck("view", 13, "occupational_disease_type"),
  controllerWrapper(viewOccupationalDiseaseType)
);

/**
 * @swagger
 * /api/occupationalDiseaseType/delete-occupational-disease-type/{id}:
 *   delete:
 *     summary: Delete a specific record of  occupational disease type
 *     tags: [ occupational disease type]
 */
occupationalDiseaseTypeRoutes.delete(
  "/delete-occupational-disease-type/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 13, "occupational_disease_type"),
  controllerWrapper(deleteOccupationalDiseaseType)
);

export default occupationalDiseaseTypeRoutes;