import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { createUpdateShiftInformation, deleteShiftInformation, viewShiftInformation } from "../controller/shiftInformationController.js";

/**
 * @swagger
 * tags:
 *   name:  shift information
 *   description: API operations for managing  shift information
 */
const shiftInformationRoutes = Router();

/**
 * @swagger
 * /api/shiftInformation/create-update-shift-information:
 *   post:
 *     summary: Create or update a  shift information
 *     tags: [ shift information]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
shiftInformationRoutes.post(
  "/create-update-shift-information",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 418 , "shift_information")(req, res, next);
  },
  controllerWrapper(createUpdateShiftInformation)
);

/**
 * @swagger
 * /api/shiftInformation/get-shift-information:
 *   get:
 *     summary: Get all records of  shift information
 *     tags: [ shift information]
 */
shiftInformationRoutes.get(
  "/get-shift-information",
  verifyToken,
  sideBarPermissionCheck("view", 418, "shift_information"),
  controllerWrapper(viewShiftInformation)
);

/**
 * @swagger
 * /api/shiftInformation/get-shift-information/{id}:
 *   get:
 *     summary: Get a specific record of  shift information
 *     tags: [ shift information]
 */
shiftInformationRoutes.get(
  "/get-shift-information/:id",
  verifyToken,
  sideBarPermissionCheck("view", 418, "shift_information"),
  controllerWrapper(viewShiftInformation)
);

/**
 * @swagger
 * /api/shiftInformation/delete-shift-information/{id}:
 *   delete:
 *     summary: Delete a specific record of  shift information
 *     tags: [ shift information]
 */
shiftInformationRoutes.delete(
  "/delete-shift-information/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 418, "shift_information"),
  controllerWrapper(deleteShiftInformation)
);

export default shiftInformationRoutes;