import { Router } from "express";

import { verifyToken } from "../helper/tokenVerify.js";
import {
  createUpdateTeams,
  deleteTeams,
  viewAllTeams,
} from "../controller/teamsController.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { validateRequest } from "../helper/general.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { createUpdateTeamsValidationSchema } from "../validationsRecord/validationSchema.js";

/**
 * @swagger
 * tags:
 *   name: Teams
 *   description: API operations for managing all teams
 */
const teamsRoutes = Router();

/**
 * @swagger
 * api/teams/create-update-teams:
 *   post:
 *     summary: Create or update a teams
 *     tags: [Teams]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id" ,name: "name" ,team_leader: "team_leader" , organization : "organization" ,description: "description" ,department : "department", team_members: "team_members" }
 *
 */

//teams sidebar id = 18; (module Id)

teamsRoutes.post(
  "/create-update-teams",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 18, "teams")(
      req,
      res,
      next
    );
  },
  validateRequest(createUpdateTeamsValidationSchema),
  controllerWrapper(createUpdateTeams)
);

/**
 * @swagger
 * api/teams/get-teams:
 *   get:
 *     summary: Get all list of teams
 *     tags: [Teams]
 */
teamsRoutes.get(
  "/get-teams",
  verifyToken,
  sideBarPermissionCheck("view", 18, "teams"),
  controllerWrapper(viewAllTeams)
);

/**
 * @swagger
 * api/teams/get-teams/{id}:
 *   get:
 *     summary: Get a specific record of teams
 *     tags: [Teams]
 */
teamsRoutes.get(
  "/get-teams/:id",
  verifyToken,
  sideBarPermissionCheck("view", 18, "teams"),
  controllerWrapper(viewAllTeams)
);

/**
 * @swagger
 * api/teams/delete-teams/{id}:
 *   delete:
 *     summary: delete a specific record of teams
 *     tags: [Teams]
 */
teamsRoutes.delete(
  "/delete-team/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 18, "teams"),
  controllerWrapper(deleteTeams)
);

export default teamsRoutes;
