import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { createUpdateTestLocation, deleteTestLocation, viewTestLocation } from "../controller/testLocationController.js";

/**
 * @swagger
 * tags:
 *   name:  test location
 *   description: API operations for managing  test location
 */
const testLocationRoutes = Router();

/**
 * @swagger
 * /api/testLocation/create-update-test-location:
 *   post:
 *     summary: Create or update a  test location
 *     tags: [ test location]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
testLocationRoutes.post(
  "/create-update-test-location",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 439 , "test_location")(req, res, next);
  },
  controllerWrapper(createUpdateTestLocation)
);

/**
 * @swagger
 * /api/testLocation/get-test-location:
 *   get:
 *     summary: Get all records of  test location
 *     tags: [ test location]
 */
testLocationRoutes.get(
  "/get-test-location",
  verifyToken,
  sideBarPermissionCheck("view", 439, "test_location"),
  controllerWrapper(viewTestLocation)
);

/**
 * @swagger
 * /api/testLocation/get-test-location/{id}:
 *   get:
 *     summary: Get a specific record of  test location
 *     tags: [ test location]
 */
testLocationRoutes.get(
  "/get-test-location/:id",
  verifyToken,
  sideBarPermissionCheck("view", 439, "test_location"),
  controllerWrapper(viewTestLocation)
);

/**
 * @swagger
 * /api/testLocation/delete-test-location/{id}:
 *   delete:
 *     summary: Delete a specific record of  test location
 *     tags: [ test location]
 */
testLocationRoutes.delete(
  "/delete-test-location/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 439, "test_location"),
  controllerWrapper(deleteTestLocation)
);

export default testLocationRoutes;