import sequelize from "./sequelize.js";
import { DataTypes } from "sequelize";
import User from "./UserSchema.js";
import Sidebar from "./SidebarSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";

const AccessRequests = sequelize.define(
  "AccessRequests",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    access_type: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    reason: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    module_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Sidebar,
        key: "id",
      },
    },
    sub_module_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Sidebar,
        key: "id",
      },
    },
    status: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
    },
    deleted: {
      type: DataTypes.BOOLEAN,
      allowNull: true,
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
  },
  {
    tableName: "access_requests",
    timestamps: false,
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

AccessRequests.belongsTo(User, { as: "CreatedBy", foreignKey: "created_by" });
AccessRequests.belongsTo(User, { as: "UpdatedBy", foreignKey: "updated_by" });
AccessRequests.belongsTo(Sidebar, {
  as: "Module",
  foreignKey: "module_id",
});
AccessRequests.belongsTo(Sidebar, {
  as: "SubModule",
  foreignKey: "sub_module_id",
});
AccessRequests.belongsTo(Organization, {
  as: "Organization",
  foreignKey: "organization",
});
AccessRequests.belongsTo(Department, {
  as: "Department",
  foreignKey: "department",
});

export default AccessRequests;
