import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import Organization from "./OrganizationSchema.js";
import Location from "./LocationSchema.js";
import Department from "./DepartmentSchema.js";
import AssetType from "./AssetTypeSchema.js";
import Currency from "./CurrencySchema.js";

const Asset = sequelize.define(
  "Asset",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    asset_name: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    asset_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    asset_type: {
      type: DataTypes.INTEGER,
      references: {
        model: AssetType,
        key: "id",
      },
      allowNull: true,
    },
    asset_description: {
      type: DataTypes.TEXT,
      allowNull: true,
    },
    model_make: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    acquisition_type: {
      type: DataTypes.ENUM("Owned", "Leased"),
      allowNull: true,
    },
    purchase_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    purchase_price: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    purchase_currency: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Currency,
        key: "id",
      },
    },
    vendor_supplier: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    leased_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    lease_price: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    lease_provider: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    lease_currency: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Currency,
        key: "id",
      },
    },
    lease_duration_value: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    lease_duration_unit: {
      type: DataTypes.ENUM("Days", "Months", "Years"),
      allowNull: true,
    },
    asset_department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
    },
    location: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Location,
        key: "id",
      },
      //   onUpdate: "CASCADE",
      //   onDelete: "SET NULL",
    },

    warranty_terms: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    warranty_expiration_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    maintenance_regime: {
      type: DataTypes.ENUM(
        "Preventive Maintenance",
        "Predictive Maintenance",
        "Corrective Maintenance",
        "Reactive Maintenance",
        "Condition-Based Maintenance",
        "Total Productive Maintenance",
        "Scheduled Maintenance",
        "Reliability-Centered Maintenance"
      ),
      allowNull: true,
    },
    conditions: {
      type: DataTypes.ENUM("New", "Used", "Damaged"),
      allowNull: true,
      defaultValue: "New",
    },
    status: {
      type: DataTypes.ENUM("Active", "Inactive", "Under repair"),
      allowNull: true,
      defaultValue: "Active",
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //   onUpdate: "CASCADE",
      //   onDelete: "SET NULL",
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //   onUpdate: "CASCADE",
      //   onDelete: "SET NULL",
    },

    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },

    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    deleted: {
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: false,
    },
  },
  {
    tableName: "asset",
    timestamps: false,
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

// Associations
Asset.belongsTo(Organization, {
  as: "OrganizationDetails",
  foreignKey: "organization",
});
Asset.belongsTo(Location, {
  as: "LocationDetails",
  foreignKey: "location",
});
Asset.belongsTo(AssetType, {
  as: "AssetTypeDetails",
  foreignKey: "asset_type",
});
Asset.belongsTo(Department, {
  as: "DepartmentDetails",
  foreignKey: "department",
});

// Sync the model
// console.log(await Asset.sync({ alter: true }));

export default Asset;
