import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import { EndFields } from "../constants/constants.js";
import Repository from "./RepositorySchema.js";
import User from "./UserSchema.js";

const AuditLog = sequelize.define(
  "audit_log",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    unique_id: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    repository_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Repository,
        key: "id",
      },
    },
    document_name: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    action_type: {
      type: DataTypes.ENUM(
        "upload",
        "edit",
        "approvals",
        "delete",
        "download",
        "view"
      ),
      allowNull: true,
    },
    document_status: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    ...EndFields,
  },
  {
    tableName: "audit_log",
    timestamps: false,
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

// console.log(await AuditLog.sync({ alter: true }));

export default AuditLog;
