import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import User from "./UserSchema.js";

const AuditTemplate = sequelize.define(
  "AuditTemplate",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    name: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    permit_type: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    permit_relation: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    organization: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
      // references: {
      //   model: Organization,
      //   key: "id",
      // },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    sections: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    passing_marks: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    quiz: {
      type: DataTypes.TINYINT,
      allowNull: true,
      defaultValue: 0,
    },
    // sections: {
    //   type: DataTypes.TEXT("long"),
    //   allowNull: true,
    // },
    employee_id: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    tableName: "audit_template",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

// Define associations with distinct names
// AuditTemplate.belongsTo(Organization, {
//   as: "org",
//   foreignKey: "organization",
// });
AuditTemplate.belongsTo(Department, {
  as: "dep",
  foreignKey: "department",
});
AuditTemplate.belongsTo(User, { as: "creator", foreignKey: "created_by" });
AuditTemplate.belongsTo(User, { as: "updater", foreignKey: "updated_by" });
// console.log(await AuditTemplate.sync({ alter: true }));
export default AuditTemplate;
