import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import { EndFields } from "../constants/constants.js";
import BcpManagement from "./BcpManagementSchema.js";
import TestLocation from "./TestLocationSchema.js";
import User from "./UserSchema.js";
import Location from "./LocationSchema.js";

const BcpTesting = sequelize.define(
  "bcp_testing",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    bcp_management_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: BcpManagement,
        key: "id",
      },
    },
    action_taken: {
      type: DataTypes.INTEGER,
      allowNull: true,
      //reference:{Custom Action Creation Table}
    },
    planned_testing_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    plan_name: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    actual_testing_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    location: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Location,
        key: "id",
      },
    },
    method: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    objective: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    test_coordinator: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
    },
    team_members: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    external_participants: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    test_scenario_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    assumptions: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    critical_function_tested: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    recovery_objectives: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    test_outcomes: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    issues_identified: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    recovery_times: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    plan_deviations: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    improvements_identified: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    // task_data: {
    //   type: DataTypes.TEXT("long"),
    //   allowNull: true,
    // },
    key_learnings: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    team_feedback: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    document_attachment: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    reviewer: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    unique_id: {
      type: DataTypes.STRING,
      allowNull: true,
    },

    ...EndFields,
  },
  {
    timestamps: false,
    tableName: "bcp_testing",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

BcpTesting.belongsTo(Location, {
  foreignKey: "location",
  as: "TestLocation",
});

// console.log(await BcpTesting.sync({ alter: true }));

// Associations
BcpTesting.belongsTo(BcpManagement, {
  as: "bcpManagementDetails",
  foreignKey: "bcp_management_id",
});

export default BcpTesting;
