import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import FileClassification from "./FileClassificationSchema.js";
import ContractorTrainingAttendance from "./ContractorTrainingAttendanceSchema.js";
import Repository from "./RepositorySchema.js";

const ContractorAttendanceDocs = sequelize.define(
  "ContractorAttendanceDocs",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    attendance_recording_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ContractorTrainingAttendance,
        key: "id",
      },
    },
    file: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    ddrm_id:{
      type: DataTypes.INTEGER,
      allowNull: true,
      references:{
        model: Repository,
        key: "id"
      }
    },
    title: {
      type: DataTypes.STRING(250),
    },
    classification: {
      type: DataTypes.INTEGER,
      references: {
        model: FileClassification,
        key: "id",
      },
    },
    deleted: {
      type: DataTypes.BOOLEAN,
      defaultValue: 0,
    },
  },
  {
    timestamps: false,
    tableName: "contractor_training_attendance_docs",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

ContractorAttendanceDocs.belongsTo(FileClassification, {
  as: "classification_details",
  foreignKey: "classification",
});

 
// console.log(await ContractorAttendanceDocs.sync({ alter: true }))
export default ContractorAttendanceDocs;
