import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import ContractorMeeting from "./ContractorMeetingSchema.js";
import User from "./UserSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";

const ContractorMeetingRecording = sequelize.define(
  "ContractorMeetingRecording",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    scheduled_meeting: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ContractorMeeting,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    for_approval: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    approval_status: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "Pending",
    },
    send_to_employee: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    actual_meeting_date_from: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    actual_meeting_date_to: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    meeting_duration: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    meeting_scriber: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    participants: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    meeting_notes: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    status: {
      type: DataTypes.ENUM("New", "Pending", "Approved", "Rejected"),
      defaultValue: "New",
    },
    comment: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    tableName: "contractor_meeting_recording",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

// Associations
ContractorMeetingRecording.belongsTo(ContractorMeeting, {
  foreignKey: "scheduled_meeting",
  as: "scheduledMeeting",
});

ContractorMeetingRecording.belongsTo(User, {
  foreignKey: "meeting_scriber",
  as: "meetingScriber",
});

ContractorMeetingRecording.belongsTo(User, {
  foreignKey: "created_by",
  as: "creator",
});

ContractorMeetingRecording.belongsTo(Organization, {
  foreignKey: "organization",
  as: "organizationReference",
});

ContractorMeetingRecording.belongsTo(Department, {
  foreignKey: "department",
  as: "departmentReference",
});

ContractorMeetingRecording.belongsTo(User, {
  foreignKey: "updated_by",
  as: "updater",
});

// console.log(await ContractorMeetingRecording.sync({ alter: true }));

export default ContractorMeetingRecording;
