import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import User from "./UserSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import ContractorRegistration from "./ContractorRegistrationSchema.js";
import ProjectRegistration from "./ProjectRegistrationSchema.js";

const ContractorMeeting = sequelize.define(
  "ContractorMeeting",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    contractor: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ContractorRegistration,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    project: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ProjectRegistration,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    meeting_id: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    meeting_title: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    meeting_hierarchy: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    participants: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
      charset: "utf8mb4",
      collate: "utf8mb4_bin",
    },
    external_participants: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
      charset: "utf8mb4",
      collate: "utf8mb4_bin",
    },
    meeting_owner: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    planned_meeting_date_from: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    planned_meeting_date_to: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    venue: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    agenda: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
  },
  {
    tableName: "contractor_meeting",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

// Associations
ContractorMeeting.belongsTo(User, {
  foreignKey: "meeting_owner",
  as: "owner",
});

ContractorMeeting.belongsTo(Organization, {
  foreignKey: "organization",
  as: "organizationReference",
});

ContractorMeeting.belongsTo(Department, {
  foreignKey: "department",
  as: "departmentReference",
});

ContractorMeeting.belongsTo(User, {
  foreignKey: "created_by",
  as: "creator",
});

ContractorMeeting.belongsTo(User, {
  foreignKey: "updated_by",
  as: "updater",
});

// console.log(await ContractorMeeting.sync({ alter: true }));

export default ContractorMeeting;
