import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import Organization from "./OrganizationSchema.js";
import Location from "./LocationSchema.js";
import Department from "./DepartmentSchema.js";
import User from "./UserSchema.js";

const FlammableStore = sequelize.define(
  "FlammableStore",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    name: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    currency: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    inspection_outcome: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    investigation_outcome: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    maintenance_frequency: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    maintenance_provider: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    ogdptype: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    root_cause: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    immediate_cause: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    inspection_checklist: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    schedule: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    action_taken: {
      type: DataTypes.INTEGER,
      allowNull: true,
      //reference:{Custom Action Creation Table}
    },
    // task_data: {
    //   type: DataTypes.TEXT("long"),
    //   allowNull: true,
    // },
    value: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    content_list: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    capacity: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    equipment_type: {
      type: DataTypes.INTEGER,
    },
    location: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Location,
        key: "id",
      },
      onUpdate: "CASCADE",
      onDelete: "SET NULL",
    },
    permit_status: {
      type: DataTypes.STRING,
      allowNull: true,
      defaultValue: "Select Permit",
    },
    last_inspection_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    inspection_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    next_inspection_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    status: {
      type: DataTypes.ENUM("Compliant", "Non-compliant"),
      allowNull: true,
      defaultValue: "Compliant",
    },
    scheduled_status: {
      type: DataTypes.ENUM("Pending", "Scheduled"),
      allowNull: true,
      defaultValue: "Pending",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      onUpdate: "CASCADE",
      onDelete: "SET NULL",
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      onUpdate: "CASCADE",
      onDelete: "SET NULL",
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      onUpdate: "CASCADE",
      onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      onUpdate: "CASCADE",
      onDelete: "SET NULL",
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    deleted: {
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: 0,
    },
  },
  {
    tableName: "flammable_store",
    timestamps: false,
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

// Associations
FlammableStore.belongsTo(Organization, {
  as: "OrganizationDetails",
  foreignKey: "organization",
});

FlammableStore.belongsTo(Location, {
  as: "LocationDetails",
  foreignKey: "location",
});

// Sync the model
// console.log(await FlammableStore.sync({ alter: true }));

export default FlammableStore;
