import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import User from "./UserSchema.js";
import AppointmentType from "./AppointmentTypeSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import Repository from "./RepositorySchema.js";

const HSEAppointment = sequelize.define(
  "HSEAppointment",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    appoints_user_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      comment: "it will be appoints user id",
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    physical_location: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    appointed_user_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      comment: "it will be appointed user id",
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    name_of_appointment: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: AppointmentType,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    effective_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    end_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    appointer_ddrm_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Repository,
        key: "id",
      },
    },
    appointed_ddrm_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Repository,
        key: "id",
      },
    },
    signature_type: {
      type: DataTypes.ENUM("electronic", "manual"),
      allowNull: true,
      defaultValue: "manual",
    },
    // signature: {
    //   type: DataTypes.STRING(255),
    //   allowNull: true,
    // },
    ddrm_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Repository,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    agreement_id: {
      type: DataTypes.STRING,
    },
    agreement_status: {
      type: DataTypes.STRING,
    },
    library_document_id: {
      type: DataTypes.STRING,
    },
    deleted: {
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: false,
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
  },
  {
    tableName: "hse_appointment",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

HSEAppointment.belongsTo(User, {
  foreignKey: "appoints_user_id",
  as: "AppointsUser",
});
HSEAppointment.belongsTo(User, {
  foreignKey: "appointed_user_id",
  as: "AppointedUser",
});
HSEAppointment.belongsTo(AppointmentType, {
  foreignKey: "name_of_appointment",
  as: "NameOfAppointment",
});
HSEAppointment.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});
HSEAppointment.belongsTo(Department, {
  foreignKey: "department",
  as: "Department",
});
HSEAppointment.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedByUser",
});
HSEAppointment.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedByUser",
});

// console.log(await HSEAppointment.sync({ alter: true }));

export default HSEAppointment;
