import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import Policy from "./PolicySchema.js";
import User from "./UserSchema.js";

const KnowledgeManagementRecodingComment = sequelize.define(
  "KnowledgeManagementRecodingComment",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    knowledge_management_recording_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Policy,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    comments: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    status: {
      type: DataTypes.ENUM("approved", "rejected"),
      allowNull: true,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
    },
  },
  {
    tableName: "policy_comments",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

KnowledgeManagementRecodingComment.belongsTo(Policy, {
  foreignKey: "knowledge_management_recording_id",
  as: "Policy",
});

KnowledgeManagementRecodingComment.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedByUser",
});

KnowledgeManagementRecodingComment.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedByUser",
});

export default KnowledgeManagementRecodingComment;
