import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import User from "./UserSchema.js";

const organizationSchema = {
  id: {
    type: DataTypes.INTEGER,
    autoIncrement: true,
    primaryKey: true,
  },
  parent_id: {
    type: DataTypes.INTEGER,
    allowNull: true,
    defaultValue: 0,
  },
  name: {
    type: DataTypes.STRING(250),
    allowNull: true,
  },
  description: {
    type: DataTypes.TEXT("long"),
    allowNull: true,
  },
  business_logo: {
    type: DataTypes.TEXT("long"),
    allowNull: true,
  },
  background_image: {
    type: DataTypes.TEXT("long"),
    allowNull: true,
  },
  header_image: {
    type: DataTypes.TEXT("long"),
    allowNull: true,
  },
  footer_image: {
    type: DataTypes.TEXT("long"),
    allowNull: true,
  },
  font_size: {
    type: DataTypes.STRING(255),
    allowNull: true,
  },
  pick_color: {
    type: DataTypes.STRING(255),
    allowNull: true,
  },
  business_address:{
    type:DataTypes.STRING(255),
    allowNull:true
  },
  unique_id: {
    type: DataTypes.STRING(255),
    allowNull: true,
  },
  level: {
    type: DataTypes.INTEGER,
    allowNull: true,
  },
  deleted: {
    type: DataTypes.INTEGER,
    allowNull: true,
    defaultValue: 0,
  },
  created_at: {
    type: DataTypes.DATE,
    allowNull: true,
    defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
  },
  created_by: {
    type: DataTypes.INTEGER,
    allowNull: true,
    references: {
      model: "users",
      key: "id",
    },
    //onUpdate: "CASCADE",
    //onDelete: "SET NULL",
  },
  updated_at: {
    type: DataTypes.DATE,
    allowNull: true,
    defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
  },
  updated_by: {
    type: DataTypes.INTEGER,
    allowNull: true,
    references: {
      model: "users",
      key: "id",
    },
    //onUpdate: "CASCADE",
    //onDelete: "SET NULL",
  },
};

const Organization = sequelize.define("Organization", organizationSchema, {
  tableName: "organization",
  timestamps: false,

  charset: "utf8mb4",
  collate: "utf8mb4_general_ci",
});

// Organization.belongsTo(User, {
//   foreignKey: "created_by",
//   as: "CreatedBy",
// });

// Organization.belongsTo(User, {
//   foreignKey: "updated_by",
//   as: "UpdatedBy",
// });
// console.log(await Organization.sync({ alter: true }));                                                                  

export { organizationSchema };
export default Organization;
