import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import Department from "./DepartmentSchema.js";
import Organization from "./OrganizationSchema.js";
import User from "./UserSchema.js";

const Responsibility = sequelize.define(
  "Responsibility",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    name: {
      type: DataTypes.STRING(200),
      allowNull: true,
    },
    description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    category: {
      type: DataTypes.STRING(200),
      allowNull: true,
    },
    priority: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      onUpdate: "CASCADE",
      onDelete: "SET NULL", // Adjust based on your logic
    },
    organization: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
      // references: {
      //   model: Organization,
      //   key: "id",
      // },
      // onUpdate: "CASCADE",
      // onDelete: "SET NULL", // Adjust based on your logic
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      // onUpdate: "CASCADE",
      // onDelete: "SET NULL", // Adjust based on your logic
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      // onUpdate: "CASCADE",
      // onDelete: "SET NULL", // Adjust based on your logic
    },
    deleted: {
      type: DataTypes.TINYINT,
      allowNull: true,
      defaultValue: 0,
    },
  },
  {
    tableName: "responsibility",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

// Associations
Responsibility.belongsTo(Department, {
  foreignKey: "department",
  as: "Department",
});

// Responsibility.belongsTo(Organization, {
//   foreignKey: "organization",
//   as: "Organization",
// });

Responsibility.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedByUser",
});

Responsibility.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedByUser",
});

// console.log(await Responsibility.sync({alter:true}))

export default Responsibility;
