import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import Organization from "./OrganizationSchema.js";
import User from "./UserSchema.js";

const Skill = sequelize.define(
  "Skill",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    name: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    organization: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
      // references: {
      //   model: Organization,
      //   key: "id",
      // },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    skills_type: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    industry: {
      type: DataTypes.TEXT({ charset: "utf8mb4", collate: "utf8mb4_bin" }),
      allowNull: true,
      comment:
        "If skills type is industry then it will store industry id in that",
    },
    is_static: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    tableName: "skills",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

// Skill.belongsTo(Organization, {
//   foreignKey: "organization",
//   as: "Organization",
// });

Skill.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedByUser",
});

Skill.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedByUser",
});

// console.log(await Skill.sync({alter:true}))

export default Skill;
