import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import TacticalRisk from "./TacticalRiskSchema.js";
import User from "./UserSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";

const TacticalRiskIdentification = sequelize.define(
  "TacticalRiskIdentification",
  {
    id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      autoIncrement: true,
      primaryKey: true,
    },
    risk_register_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: TacticalRisk,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    risk_owner: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    risk_name: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    risk_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    impact_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    causes_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    inherent_likelihood: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    inherent_consequence: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    inherent_risk_rating: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    inherent_risk_ranking: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    control_id: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    // control_name: {
    //   type: DataTypes.STRING(500),
    //   allowNull: true,
    // },
    // control_description: {
    //   type: DataTypes.TEXT("long"),
    //   allowNull: true,
    // },
    // control_design_intent: {
    //   type: DataTypes.STRING(500),
    //   allowNull: true,
    // },
    // control_effectiveness: {
    //   type: DataTypes.STRING(500),
    //   allowNull: true,
    // },
    // control_owner: {
    //   type: DataTypes.INTEGER,
    //   allowNull: true,
    //   references: {
    //     model: User,
    //     key: "id",
    //   },
    //   //onUpdate: "CASCADE",
    //   //onDelete: "SET NULL",
    // },
    residual_risk_rating: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    residual_risk_ranking: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    tactical_identification: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    opportunity_identification: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    opportunity_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    priority_confirmation: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: null,
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    tableName: "tactical_risk_identification",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

TacticalRiskIdentification.belongsTo(TacticalRisk, {
  foreignKey: "risk_register_id",
  as: "TacticalRisk",
});

TacticalRiskIdentification.belongsTo(User, {
  foreignKey: "risk_owner",
  as: "RiskOwner",
});

TacticalRiskIdentification.belongsTo(User, {
  foreignKey: "control_owner",
  as: "ControlOwner",
});

TacticalRiskIdentification.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});

TacticalRiskIdentification.belongsTo(Department, {
  foreignKey: "department",
  as: "Department",
});

TacticalRiskIdentification.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedBy",
});

TacticalRiskIdentification.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedBy",
});
// console.log(await TacticalRiskIdentification.sync({ alter: true }));
export default TacticalRiskIdentification;
