import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import User from "./UserSchema.js";

const TrainingNeedAnalysis = sequelize.define(
  "TrainingNeedAnalysis",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    training_need_analysis: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    training_type: {
      type: DataTypes.STRING(250),
      allowNull: true,
      // Training , Awareness
    },
    training_name: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    training_color: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    training_purpose: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    training_for: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    role: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    training_awareness: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    training_purpose: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    approval_status: {
      type: DataTypes.STRING(50),
      defaultValue: "Pending",
      allowNull: true,
    },
    send_to_employee: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    for_approval: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    created_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      allowNull: true,
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    timestamps: false,

    tableName: "training_need_analysis",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

TrainingNeedAnalysis.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});

TrainingNeedAnalysis.belongsTo(Department, {
  foreignKey: "department",
  as: "Department",
});

TrainingNeedAnalysis.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedBy",
});

TrainingNeedAnalysis.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedBy",
});

// console.log(await TrainingNeedAnalysis.sync({ alter: true }));
export default TrainingNeedAnalysis;
