import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import BcpManagement from "./BcpManagementSchema.js";
import User from "./UserSchema.js";
import Repository from "./RepositorySchema.js";
import PermitLicenseCompliance from "./PermitLicenseComplianceSchema.js";

const UserPermitAndLicenseDocs = sequelize.define(
  "UserPermitAndLicenseDocs",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    doc_no: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    user_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    name: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    file: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    checked: {
      type: DataTypes.BOOLEAN,
      allowNull: true,
    },
    permit_license_compliance: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: PermitLicenseCompliance,
        key: "id",
      },
    },
    ddrm_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Repository,
        key: "id",
      },
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
  },
  {
    tableName: "user_permit_license_docs",
    timestamps: false,
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);
// console.log(await UserPermitAndLicenseDocs.sync({ alter: true }));

export default UserPermitAndLicenseDocs;
