import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import AgreementResponse from "./agreementResponseSchema.js";

const AgreementResponseDocs = sequelize.define(
  "AgreementResponseDocs",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    doc_no: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    agreement_response_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: AgreementResponse,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    title: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    file: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
  },
  {
    tableName: "agreement_response_docs",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

// console.log(await AgreementResponseDocs.sync({ alter: true }));
export default AgreementResponseDocs;
