import Joi from "joi";
import moment from "moment";
/**Validation to check while login users data is coming or not */
export const userLoginSchema = Joi.object({
  field: Joi.string().required().messages({
    "any.required": "Email or Employee ID is required.",
    "string.empty": "Email or Employee ID must not be empty.",
  }),
  password: Joi.string().min(6).required().messages({
    "any.required": "Password is required.",
    "string.empty": "Password must not be empty.",
    "string.min": "Password must be at least {#limit} characters long.",
  }),
}).options({ allowUnknown: true });

/**Validation to check while forgot password details is coming properly */
export const forgotPasswordValidationSchema = Joi.object({
  field: Joi.string().required().messages({
    "any.required": "Email or Employee ID is required.",
    "string.empty": "Email or Employee ID must not be empty.",
  }),
}).options({ allowUnknown: true });

/**Validation to check while otp verify data is coming properly */
export const otpVerifyValidationSchema = Joi.object({
  field: Joi.string().required().messages({
    "any.required": "Email or Employee ID is required.",
    "string.empty": "Email or Employee ID must not be empty.",
  }),
  otp: Joi.string()
    .pattern(/^\d{6}$/)
    .required()
    .messages({
      "any.required": "OTP is required.",
      "string.pattern.base": "OTP must be a 6-digit number.",
    }),
}).options({ allowUnknown: true });

/**Validation to check while otp verify data is coming properly */
export const passwordChangeValidationSchema = Joi.object({
  // field: Joi.string().required().messages({
  //   "any.required": "Email or Employee ID is required.",
  //   "string.empty": "Email or Employee ID must not be empty.",
  // }),
  password: Joi.required().messages({
    "any.required": "Password is required.",
  }),
}).options({ allowUnknown: true });

//  {{{{    PluginUser Validation Schema    }}}}
/**For creating an employee check validation */

/** Validation for checking organization */
export const organizationCreateUpdateValidationSchema = Joi.object({
  name: Joi.string().required().messages({
    "any.required": "Name is required.",
    "string.empty": "Name must not be empty.",
  }),
}).options({ allowUnknown: true });

//  {{{{    Department Validation Schema    }}}}
export const departmentCreateUpdateValidationSchema = Joi.object({
  name: Joi.required().messages({
    "any.required": "Name is required.",
    "string.empty": "Name must not be empty.",
  }),
}).options({ allowUnknown: true });

/**  Incident Category Validation Schema  */
export const incidentCategoryCreateUpdateValidationSchema = Joi.object({
  name: Joi.required().messages({
    "any.required": "Name is required.",
    "string.empty": "Name must not be empty.",
  }),
}).options({ allowUnknown: true });

/** Responsibility Validation Schema  */

export const responsibilityCreateUpdateValidationSchema = Joi.object({
  name: Joi.string().required().messages({
    "any.required": "Responsibility Name is required.",
    "string.empty": "Responsibility Name must not be empty.",
  }),
}).options({ allowUnknown: true });

/**Issuing Authority Validation Schema*/
export const issuingAuthorityCreateUpdateValidationSchema = Joi.object({
  name: Joi.required().messages({
    "any.required": "Name is required.",
    "string.empty": "Name must not be empty.",
  }),
}).options({ allowUnknown: true });

/**Permit License Validation Schema*/
export const permitLicenseCreateUpdateValidationSchema = Joi.object({
  name: Joi.required().messages({
    "any.required": "Name is required.",
    "string.empty": "Name must not be empty.",
  }),
}).options({ allowUnknown: true });

/**Focus Area Validation Schema*/
export const focusAreaCreateUpdateValidationSchema = Joi.object({
  name: Joi.required().messages({
    "any.required": "Name is required.",
    "string.empty": "Name must not be empty.",
  }),
}).options({ allowUnknown: true });

/**Document Type Validation Schema*/
export const documentTypeCreateUpdateValidationSchema = Joi.object({
  name: Joi.required().messages({
    "any.required": "Name is required.",
    "string.empty": "Name must not be empty.",
  }),
}).options({ allowUnknown: true });

/**Audit Category Validation Schema*/
export const auditCategoryCreateUpdateValidationSchema = Joi.object({
  name: Joi.required().messages({
    "any.required": "Name is required.",
    "string.empty": "Name must not be empty.",
  }),
}).options({ allowUnknown: true });
/**Validation to check while login users data is coming or not */
export const skillCreateUpdateValidationSchema = Joi.object({
  name: Joi.required().messages({
    "any.required": "Name is required.",
    "string.empty": "Name must not be empty.",
  }),
  skill_type: Joi.required().messages({
    "any.required": "skill type is required.",
    "string.empty": "skill type must not be empty.",
  }),
}).options({ allowUnknown: true });

export const licenseCreateUpdateValidationSchema = Joi.object({
  name: Joi.string().required().messages({
    "any.required": "Name is required.",
    "string.empty": "Name must not be empty.",
  }),
}).options({ allowUnknown: true });

export const appointmentTypeValidationSchema = Joi.object({
  name: Joi.string().required().messages({
    "any.required": "Name is required",
    "string.empty": "Name must not be empty",
  }),
  assignment: Joi.string().required().messages({
    "any.required": "Assignment is required",
    "string.empty": "Assignment must not be empty",
  }),
  designated: Joi.string().required().messages({
    "any.required": "Designated function is required",
    "string.empty": "Designated function must not be empty",
  }),
  applicable: Joi.string().required().messages({
    "any.required": "Applicable function is required",
    "string.empty": "Applicable function must not be empty",
  }),
}).options({
  allowUnknown: true,
});

/**Validation to check while login users data is coming or not */
export const parentObjectiveValidationSchema = Joi.object({
  name: Joi.required().messages({
    "any.required": "Parent objective is required.",
    "string.empty": "Parent objective must not be empty.",
  }),
}).options({ allowUnknown: true });

/**Validation While create or update measurement metric */
export const measurementMetricCreateUpdateValidationSchema = Joi.object({
  name: Joi.required().messages({
    "any.required": "Measurement Metric title is required.",
    "string.empty": "Measurement Metric title  must not be empty.",
  }),
}).options({ allowUnknown: true });

/**Validation While create or update category type */
export const categoryTypeCreateUpdateValidationSchema = Joi.object({
  name: Joi.required().messages({
    "any.required": "Category name is required.",
    "string.empty": "Category name must not be empty.",
  }),
}).options({ allowUnknown: true });

/** Validation while creating or updating action template */
const commonErrorMessages = (field) => ({
  "any.required": `${field} is required.`,
  "string.empty": `${field} must not be empty.`,
  "number.base": `${field} must be a number.`,
  "boolean.base": `${field} must be a boolean.`,
  "array.base": `${field} must be an array.`,
  "object.base": `${field} must be an object.`,
});

export const auditTemplateCreateUpdateValidationSchema = Joi.object({
  name: Joi.string().required().messages(commonErrorMessages("Template name")),
  description: Joi.string().allow("").optional(), // Assuming description is optional
  organization: Joi.array().items(Joi.number()).optional(), // Assuming organization is an array of strings
  quiz: Joi.number().integer().optional(), // Assuming quiz is an optional integer
  sections: Joi.array()
    .items(
      Joi.object({
        name: Joi.string()
          .required()
          .messages(commonErrorMessages("Section name")),
        label: Joi.string().optional(), // Added label for the section
        description: Joi.string().allow("").optional(), // Assuming section description is optional
        quiz: Joi.boolean().optional().messages(commonErrorMessages("Quiz")), // Assuming quiz is a boolean
        questions: Joi.array()
          .items(
            Joi.object({
              question_no: Joi.number()
                .integer()
                .messages(commonErrorMessages("Question number")),
              label: Joi.string().optional(), // Added label for the question
              answer_type: Joi.string()
                .valid(
                  "Multiple Choice",
                  "Dropdown",
                  "Checkbox",
                  "Paragraph",
                  "Linear Scale",
                  "Date",
                  "Time"
                )
                .required()
                .messages(commonErrorMessages("Answer type")),
              answer_key: Joi.any(),
              points: Joi.alternatives()
                .try(Joi.number(), Joi.array().items(Joi.any())) // Handle cases where points can be either number or array
                .optional(),
              options: Joi.array().items(Joi.string()).optional(), // Assuming options is an array of strings
              question_title: Joi.string()
                .required()
                .messages(commonErrorMessages("Question title")),
              required: Joi.boolean()
                .optional()
                .messages(commonErrorMessages("Required")), // Assuming required is a boolean
            })
          )
          .required()
          .messages(commonErrorMessages("Questions")),
      })
    )
    .required()
    .messages(commonErrorMessages("Sections array")),
}).options({ allowUnknown: true });

/** Validation While create or update roles */
export const rolesCreateUpdateValidationSchema = Joi.object({
  level: Joi.required().messages({
    "any.required": "Level is required.",
  }),
  hierarchy: Joi.required().messages({
    "any.required": "Hierarchy is required",
  }),
  description: Joi.string().required().messages({
    "any.required": "Role Description is required",
    "string.empty": "Role description must not be empty",
  }),
  qualification: Joi.required().messages({
    "any.required": "Qualification is required",
  }),
  year_of_experience: Joi.required().messages({
    "any.required": "Years of experience is required",
  }),
  name: Joi.string().required().messages({
    "any.required": "Role Name is required.",
    "string.empty": "Role Name must not be empty.",
  }),
  skills: Joi.array().required().messages({
    "any.required": "Skills is required.",
  }),
  // organization: Joi.allow("")
  //   .required()
  //   .custom((value, helpers) => {
  //     const department = helpers.state.ancestors[0].schema.$_terms.keys.find(
  //       (key) => key.key === "department"
  //     );
  //     if (department) {
  //       if (value === "") {
  //         return helpers.error("any.required");
  //       }
  //       return value;
  //     }
  //     return value;
  //   })
  //   .messages({
  //     "any.required": "Either Organization or Department is required.",
  //     "string.empty":
  //       "Organization cannot be empty when Department is not provided.",
  //   }),
  // department: Joi.allow("")
  //   .required()
  //   .custom((value, helpers) => {
  //     const organization = helpers.state.ancestors[0].schema.$_terms.keys.find(
  //       (key) => key.key === "organization"
  //     );
  //     if (organization) {
  //       if (value === "") {
  //         return helpers.error("any.required");
  //       }
  //       return value;
  //     }
  //     return value;
  //   })
  //   .messages({
  //     "any.required": "Either Organization or Department is required.",
  //     "string.empty":
  //       "Department cannot be empty when Organization is not provided.",
  //   }),
}).options({ allowUnknown: true });

/**For create Meeting validation */
export const meetingCreateUpdateSchema = Joi.object({
  meeting_owner: Joi.number().integer().required().messages({
    "any.required": "Meeting Owner is required.",
    "number.base": "Meeting Owner must be number.",
  }),
  meeting_hierarchy: Joi.required().messages({
    "any.required": "Meeting hierarchy is required",
  }),
  meeting_title: Joi.required().messages({
    "any.required": "Meeting title is required",
  }),

  venue: Joi.string().required().messages({
    "any.required": "Venue is required.",
    "string.empty": "Venue must not be empty.",
  }),
  planned_meeting_date_from: Joi.date().required().messages({
    "any.required": "Planned meeting start date is required.",
    "date.base": "Planned meeting start date must be a valid date.",
  }),
  planned_meeting_date_to: Joi.date().required().messages({
    "any.required": "Planned meeting end date is required.",
    "date.base": "Planned meeting end date must be a valid date.",
  }),
}).options({ allowUnknown: true });
export const updateEmployeeSchema = Joi.object({
  organization: Joi.string().required().messages({
    "any.required": "Organization is required.",
    "string.empty": "Organization must not be empty.",
  }),
  name: Joi.string().required().messages({
    "any.required": "Name is required.",
    "string.empty": "Name must not be empty.",
  }),
  surname: Joi.string().required().messages({
    "any.required": "Surname is required.",
    "string.empty": "Surname must not be empty.",
  }),
  // passport_number: Joi.string().required().messages({
  //   'any.required': 'Passport Number is required.',
  // }),
  gender: Joi.string().required().messages({
    "any.required": "Gender is required.",
  }),
  visa_number: Joi.string().required().messages({
    "any.required": "Work Permit Visa Number is required.",
  }),
  work_permit_expiry_date: Joi.date().required().messages({
    "any.required": "Work Permit Expiry Date is required.",
    "date.format": "Invalid date format.",
  }),
  national_id: Joi.string()
    .valid("South African", "Other")
    .required()
    .messages({
      "any.required": "Nationality is required.",
      "any.only": "Invalid nationality.",
    }),
  id_number: Joi.string().when("national_id", {
    is: "South African",
    then: Joi.string()
      .pattern(/^\d{13}$/)
      .required()
      .messages({
        "string.pattern.base": "South African ID must be a 13-digit number.",
        "any.required": "South African ID Number is required.",
      }),
    otherwise: Joi.optional(),
  }),
  date_of_birth: Joi.date().required().messages({
    "any.required": "Date of Birth is required.",
    // "date.base": "Invalid date format.",
  }),
  marital_status: Joi.string().required().messages({
    "any.required": "Marital Status is required.",
  }),
  person_with_disabilities: Joi.string().required().messages({
    "any.required": "Disabilities status is required.",
  }),
  race: Joi.string().required().messages({
    "any.required": "Race is required.",
  }),
  highest_qualification: Joi.string().required().messages({
    "any.required": "Highest Qualification is required.",
  }),
  name_of_qualification: Joi.string().required().messages({
    "any.required": "Name of Qualification is required.",
  }),
  country: Joi.string().required().messages({
    "any.required": "Country is required.",
  }),
  state: Joi.string().required().messages({
    "any.required": "Province is required.",
  }),
  city: Joi.string().required().messages({
    "any.required": "City is required.",
  }),
  current_address: Joi.string().required().messages({
    "any.required": "Current Address is required.",
  }),
  phone: Joi.string().required().messages({
    "any.required": "Phone Number is required.",
  }),
  email: Joi.string().email().required().messages({
    "any.required": "Email Address is required.",
    "string.email": "Invalid email format.",
  }),
  employee_number: Joi.string().required().messages({
    "any.required": "Employee Number is required.",
  }),
  role: Joi.string().required().messages({
    "any.required": "Role is required.",
  }),
  // department: Joi.string().required().messages({
  //   "any.required": "Department is required.",
  // }),
  employment_type: Joi.string().required().messages({
    "any.required": "Employment Type is required.",
  }),
  employment_status: Joi.string().required().messages({
    "any.required": "Employment Status is required.",
  }),
  date_of_employment: Joi.date().required().messages({
    "any.required": "Date of Employment is required.",
    "date.format": "Invalid date format.",
  }),
  start_probation_period: Joi.date().required().messages({
    "any.required": "Start Probation Period is required.",
  }),
  end_probation_period: Joi.date().required().messages({
    "any.required": "End Probation Period is required.",
  }),
  date_of_termination: Joi.date().optional().messages({
    "date.base": "Invalid date format.",
  }),
  reason_for_employee_becoming_inactive: Joi.string().optional().messages({
    "any.required": "Reason is required.",
  }),
  work_location: Joi.string().required().messages({
    "any.required": "Work Location is required.",
  }),
  manager: Joi.string().required().messages({
    "any.required": "Manager Name is required.",
  }),
  tax_residency_status: Joi.string().required().messages({
    "any.required": "Tax Residency Status is required.",
  }),
  income_tax_number: Joi.string()
    .pattern(/^\d{10}$/)
    .required()
    .messages({
      "any.required": "Income Tax Number is required.",
      "string.pattern.base": "Income Tax Number must be exactly 10 digits.",
    }),
  bank_name: Joi.string().required().messages({
    "any.required": "Bank Name is required.",
  }),
  account_number: Joi.string().required().messages({
    "any.required": "Account Number is required.",
  }),
  branch_code: Joi.string().required().messages({
    "any.required": "Branch Code is required.",
  }),
  account_type: Joi.string().required().messages({
    "any.required": "Account Type is required.",
  }),
  allergies: Joi.string().required().messages({
    "any.required": "Allergies are required.",
  }),
  current_medications: Joi.string().required().messages({
    "any.required": "Current Medications are required.",
  }),
  blood_type: Joi.string().required().messages({
    "any.required": "Blood Type is required.",
  }),
  vaccination_records: Joi.string().required().messages({
    "any.required": "Vaccination Records are required.",
  }),
}).options({ allowUnknown: true });

// export const createEmployeeSchema = Joi.object({
//   name: Joi.string().required().messages({
//     "any.required": "first name is required.",
//     "string.empty": "first name must not be empty.",
//   }),
//   surname: Joi.string().required().messages({
//     "any.required": "surname is required.",
//     "string.empty": "surname not be empty.",
//   }),
//   gender: Joi.string().required().messages({
//     "any.required": "gender is required.",
//     "string.empty": "gender not be empty.",
//   }),
//   phone: Joi.number().required().messages({
//     "any.required": "Phone Number is required",
//   }),
//   id_number: Joi.required().messages({
//     "any.required": "National ID / Passport is required",
//   }),
//   joining_date: Joi.date().messages({
//     "date.format": "Joining Date must be a valid date",
//   }),
//   disability: Joi.required().messages({
//     "any.required": "Disability Status is required",
//   }),
//   race: Joi.required().messages({
//     "any.required": "Race is required",
//   }),
//   highest_qualification: Joi.required().messages({
//     "any.required": "Highest Qualification  is required",
//   }),
//   name_of_qualification: Joi.required().messages({
//     "any.required": "Name of qualification  is required",
//   }),
//   skills: Joi.required().messages({
//     "any.required": "Skills are required",
//   }),
//   country: Joi.required().messages({
//     "any.required": "Country is required",
//   }),
//   state: Joi.required().messages({
//     "any.required": "Province is required",
//   }),
//   city: Joi.required().messages({
//     "any.required": "City is required",
//   }),
//   current_add: Joi.required().messages({
//     "any.required": "Employee's current address is required",
//   }),
//   accountability: Joi.required().messages({
//     "any.required": "Accountability is required",
//   }),
//   role: Joi.required().messages({
//     "any.required": "Role Id is required.",
//     "string.empty": "Role Id must not be empty.",
//   }),
// }).options({ allowUnknown: true });

// Helper function for date validation based on ID
const validateDOBFromID = (value, helpers) => {
  const idNumber = helpers.state.ancestors[0].id_number;
  const dobFromID = extractDateOfBirthFromID(idNumber); // Assuming this function is defined
  if (moment(value).isSame(moment(dobFromID))) {
    return value;
  }
  return helpers.message("Invalid Date of Birth derived from ID");
};

export const createEmployeeSchema = Joi.object({
  organization: Joi.string().required().messages({
    "any.required": "Organization is required.",
    "string.empty": "Organization must not be empty.",
  }),
  name: Joi.string().required().messages({
    "any.required": "Name is required.",
    "string.empty": "Name must not be empty.",
  }),
  surname: Joi.string().required().messages({
    "any.required": "Surname is required.",
    "string.empty": "Surname must not be empty.",
  }),
  passport_number: Joi.string().required().messages({
    "any.required": "Passport Number is required.",
  }),
  gender: Joi.string().required().messages({
    "any.required": "Gender is required.",
  }),
  visa_number: Joi.string().required().messages({
    "any.required": "Work Permit Visa Number is required.",
  }),
  work_permit_expiry_date: Joi.date().required().messages({
    "any.required": "Work Permit Expiry Date is required.",
    "date.format": "Invalid date format.",
  }),
  national_id: Joi.string()
    .valid("South African", "Other")
    .required()
    .messages({
      "any.required": "Nationality is required.",
      "any.only": "Invalid nationality.",
    }),
  // id_number: Joi.string().when('national_id', {
  //   is: 'South African',
  //   then: Joi.string()
  //     .pattern(/^\d{13}$/)
  //     .required()
  //     .messages({
  //       'string.pattern.base': 'South African ID must be a 13-digit number.',
  //       'any.required': 'South African ID Number is required.',
  //     }),
  //   otherwise: Joi.optional(),
  // }),
  date_of_birth: Joi.date().required().messages({
    "any.required": "Date of Birth is required.",
    // "date.base": "Invalid date format.",
  }),
  marital_status: Joi.string().required().messages({
    "any.required": "Marital Status is required.",
  }),
  person_with_disabilities: Joi.string().required().messages({
    "any.required": "Disabilities status is required.",
  }),
  race: Joi.string().required().messages({
    "any.required": "Race is required.",
  }),
  highest_qualification: Joi.string().required().messages({
    "any.required": "Highest Qualification is required.",
  }),
  name_of_qualification: Joi.string().required().messages({
    "any.required": "Name of Qualification is required.",
  }),
  country: Joi.string().required().messages({
    "any.required": "Country is required.",
  }),
  state: Joi.string().required().messages({
    "any.required": "Province is required.",
  }),
  city: Joi.string().required().messages({
    "any.required": "City is required.",
  }),
  current_address: Joi.string().required().messages({
    "any.required": "Current Address is required.",
  }),
  phone: Joi.string().required().messages({
    "any.required": "Phone Number is required.",
  }),
  email: Joi.string().email().required().messages({
    "any.required": "Email Address is required.",
    "string.email": "Invalid email format.",
  }),
  employee_number: Joi.string().required().messages({
    "any.required": "Employee Number is required.",
  }),
  role: Joi.string().required().messages({
    "any.required": "Role is required.",
  }),
  // department: Joi.string().required().messages({
  //   "any.required": "Department is required.",
  // }),
  employment_type: Joi.string().required().messages({
    "any.required": "Employment Type is required.",
  }),
  employment_status: Joi.string().required().messages({
    "any.required": "Employment Status is required.",
  }),
  date_of_employment: Joi.date().required().messages({
    "any.required": "Date of Employment is required.",
    "date.format": "Invalid date format.",
  }),
  start_probation_period: Joi.date().required().messages({
    "any.required": "Start Probation Period is required.",
  }),
  end_probation_period: Joi.date().required().messages({
    "any.required": "End Probation Period is required.",
  }),
  date_of_termination: Joi.date().optional().messages({
    "date.base": "Invalid date format.",
  }),
  reason_for_employee_becoming_inactive: Joi.string().optional().messages({
    "any.required": "Reason is required.",
  }),
  work_location: Joi.string().required().messages({
    "any.required": "Work Location is required.",
  }),
  manager: Joi.string().required().messages({
    "any.required": "Manager Name is required.",
  }),
  tax_residency_status: Joi.string().required().messages({
    "any.required": "Tax Residency Status is required.",
  }),
  income_tax_number: Joi.string()
    .pattern(/^\d{10}$/)
    .required()
    .messages({
      "any.required": "Income Tax Number is required.",
      "string.pattern.base": "Income Tax Number must be exactly 10 digits.",
    }),
  bank_name: Joi.string().required().messages({
    "any.required": "Bank Name is required.",
  }),
  account_number: Joi.string().required().messages({
    "any.required": "Account Number is required.",
  }),
  branch_code: Joi.string().required().messages({
    "any.required": "Branch Code is required.",
  }),
  account_type: Joi.string().required().messages({
    "any.required": "Account Type is required.",
  }),
  allergies: Joi.string().required().messages({
    "any.required": "Allergies are required.",
  }),
  current_medications: Joi.string().required().messages({
    "any.required": "Current Medications are required.",
  }),
  blood_type: Joi.string().required().messages({
    "any.required": "Blood Type is required.",
  }),
  vaccination_records: Joi.string().required().messages({
    "any.required": "Vaccination Records are required.",
  }),
}).options({ allowUnknown: true });

export const hseAppointmentCreateUpdateValidationSchema = Joi.object({
  appoints_user_id: Joi.number().required().messages({
    "any.required": "Appoints user id is required.",
    "number.base": "Appoints user id must be a number.",
  }),
  // legal_appointment_role: Joi.number().required().messages({
  //   "any.required": "Legal Appointment role id is required.",
  //   "number.base": "Legal Appointment role id must be a number.",
  // }),
  appointed_user_id: Joi.required().messages({
    "any.required": "Appointed user id of Appointment is required.",
    "string.empty": "Appointed user id of Appointment must not be empty.",
  }),
  effective_date: Joi.date().required().iso().messages({
    "any.required": "Effective date is required.",
    "date.base": "Effective date must be a valid date.",
    "date.format": "Effective date must be in Proper format.",
  }),
}).options({ allowUnknown: true });

export const strategicRiskValidationSchema = Joi.object({
  risk_register_name: Joi.string().required().messages({
    "any.required": "Risk register name is required.",
    "string.empty": "Risk register name must not be empty.",
  }),
  // meeting_id: Joi.required().messages({
  //   'any.required': 'Meeting id is required.',
  // }),
  // risk_context: Joi.required().messages({
  //   'any.required': 'Risk Context is required.',
  // }),
}).options({ allowUnknown: true });

export const strategicRiskIdentificationValidationSchema = Joi.object({
  risk_name: Joi.string().required().messages({
    "any.required": "Risk name is required.",
    "string.empty": "Risk name must not be empty.",
  }),
  risk_owner: Joi.required().messages({
    "any.required": "Risk owner is required.",
  }),
  risk_description: Joi.string().required().messages({
    "any.required": "Risk description is required.",
    "string.empty": "Risk description must not be empty.",
  }),
  impact_description: Joi.string().required().messages({
    "any.required": "Impact description is required.",
    "string.empty": "Impact description must not be empty.",
  }),
  causes_description: Joi.string().required().messages({
    "any.required": "Causes description is required.",
    "string.empty": "Causes description must not be empty.",
  }),
  inherent_likelihood: Joi.required().messages({
    "any.required": "Inherent likelihood is required.",
  }),
  inherent_consequence: Joi.required().messages({
    "any.required": "Inherent consequence is required.",
  }),
  control_name: Joi.required().messages({
    "any.required": "Control Name is required",
  }),
  control_description: Joi.required().messages({
    "any.required": "Control description is required",
  }),
  control_design_intent: Joi.required().messages({
    "any.required": "Control design intent is required",
  }),
  control_effectiveness: Joi.required().messages({
    "any.required": "Control effectiveness is required",
  }),
  control_owner: Joi.required().messages({
    "any.required": "Control owner is required",
  }),
  priority_confirmation: Joi.required().messages({
    "any.required": "Priority confirmation is required.",
  }),
}).options({ allowUnknown: true });

export const meetingCreateUpdateRecordingSchema = Joi.object({
  scheduled_meeting: Joi.number().required().messages({
    "any.required": "Scheduled Meeting is required.",
    "number.base": "Scheduled Meeting must be a number.",
  }),
  actual_meeting_date_from: Joi.date().required().messages({
    "any.required": "Planned meeting start date is required.",
    "date.base": "Planned meeting start date must be a valid date.",
  }),
  actual_meeting_date_to: Joi.date().required().messages({
    "any.required": "Planned meeting end date is required.",
    "date.base": "Planned meeting end date must be a valid date.",
  }),
  meeting_duration: Joi.string().required().messages({
    "any.required": "Meeting Duration is required.",
    "string.empty": "Meeting Duration must not be empty.",
  }),
  meeting_scriber: Joi.number().required().messages({
    "any.required": "Meeting scribe is required.",
    "number.base": "Meeting scribe must be a number.",
  }),
  meeting_notes: Joi.array()
    .items(
      Joi.object({
        agenda_item: Joi.string().required().messages({
          "any.required": "Agenda item is required.",
          "string.empty": "Agenda item must not be empty.",
        }),
        raised_by: Joi.number().required().messages({
          "any.required": "Raised by is required.",
          "number.base": "Raised by must be a number.",
        }),
      })
    )
    .label("meetingNotes")
    .required()
    .messages({
      "any.required": "Meeting notes are required.",
      "array.base": "Meeting notes must be an array.",
      "array.empty": "Meeting notes array must not be empty.",
    }),
  organization: Joi.alternatives()
    .try(
      Joi.required().messages({
        "any.required": "Organization is required.",
      }),
      Joi.required().messages({
        "any.required": "Department is required.",
      })
    )
    .messages({
      "alternatives.any": "Either organization or department is required.",
    }),
}).options({ allowUnknown: true });

export const tacticalRiskIdentificationValidationSchema = Joi.object({
  risk_name: Joi.string().required().messages({
    "any.required": "Risk name is required.",
    "string.empty": "Risk name must not be empty.",
  }),
  risk_owner: Joi.required().messages({
    "any.required": "Risk owner is required.",
  }),
  risk_description: Joi.string().required().messages({
    "any.required": "Risk description is required.",
    "string.empty": "Risk description must not be empty.",
  }),
  impact_description: Joi.string().required().messages({
    "any.required": "Impact description is required.",
    "string.empty": "Impact description must not be empty.",
  }),
  causes_description: Joi.string().required().messages({
    "any.required": "Causes description is required.",
    "string.empty": "Causes description must not be empty.",
  }),
  inherent_likelihood: Joi.required().messages({
    "any.required": "Inherent likelihood is required.",
  }),
  inherent_consequence: Joi.required().messages({
    "any.required": "Inherent consequence is required.",
  }),
  control_name: Joi.required().messages({
    "any.required": "Control Name is required",
  }),
  control_description: Joi.required().messages({
    "any.required": "Control description is required",
  }),
  control_design_intent: Joi.required().messages({
    "any.required": "Control design intent is required",
  }),
  control_effectiveness: Joi.required().messages({
    "any.required": "Control effectiveness is required",
  }),
  control_owner: Joi.required().messages({
    "any.required": "Control owner is required",
  }),
  priority_confirmation: Joi.required().messages({
    "any.required": "Priority confirmation is required.",
  }),
}).options({ allowUnknown: true });

/**Validation While create or update objective setting type */
export const objectiveSettingCreateUpdateValidationSchema = Joi.object({
  objective_owner: Joi.required().messages({
    "any.required": "Objective owner is required",
  }),
  date_generated: Joi.date().required().messages({
    "any.required": "Objective owner is required",
    "date.format": "Date generated must be in a valid format",
  }),
  objective_description: Joi.string().required().messages({
    "any.required": "Objective Description is required",
  }),
  measurement_metric: Joi.required().messages({
    "any.required": "Measurement metric is required",
  }),
  numeric_value: Joi.number().required().messages({
    "any.required": "Numeric value is required",
  }),
  target_name: Joi.required().messages({
    "any.required": "Target names is required",
  }),
  target_description: Joi.required().messages({
    "any.required": "Target description is required",
  }),
  management_plan_name: Joi.string().required().messages({
    "any.required": "Management plan name is required",
  }),
  management_plan_description: Joi.required().messages({
    "any.required": "Management plan description is required",
  }),
}).options({ allowUnknown: true });

/**Validation While create or update audit scheduling */
export const auditSchedulingCreateUpdateValidationSchema = Joi.object({
  // audit_name: Joi.string().required().messages({
  //     'any.required': 'Audit Name is required.',
  //     'string.empty': 'Audit Name must not be empty.',
  // }),
  audit_type: Joi.string().required().messages({
    "any.required": "Audit Type is required.",
    "string.empty": "Audit Type must not be empty.",
  }),
  planned_audit_start_date_time: Joi.string().required().messages({
    "any.required": "Planned Audit Start Date is required.",
    "string.empty": "Planned Audit Start Date must not be empty.",
  }),
  planned_audit_end_date_time: Joi.string().required().messages({
    "any.required": "Planned Audit End Date is required.",
    "string.empty": "Planned Audit End Date must not be empty.",
  }),
  audit_category: Joi.number().required().messages({
    "any.required": "Audit Category is required.",
    "number.base": "Audit Category must be a number.",
  }),
  audit_focus_area: Joi.any().required().messages({
    "any.required": "Audit Focus Area is required.",
  }),
  // auditor_lead: Joi.any().required().messages({
  //     'any.required': 'Auditor Lead is required.',
  // }),
  // auditor_members: Joi.any().required().messages({
  //     'any.required': 'Auditor Members are required.',
  // }),
  // audit_scope: Joi.string().messages({
  //     'string.empty': 'Audit Scope must not be empty.',
  // }),
  // location: Joi.string().messages({
  //     'string.empty': 'Location must not be empty.',
  // }),
  // critical_business_processes: Joi.string().messages({
  //     'string.empty': 'Critical Business Processes must not be empty.',
  // }),
  //   allocation_human_resource: Joi.any().messages({
  //     "any.required": "Allocation of Human Resource is required.",
  //   }),
  //   technological_resources: Joi.any().messages({
  //     "any.required": "Technological Resources are required.",
  //   }),
  //   type_of_resources: Joi.string().messages({
  //     "string.empty": "Type of Resources must not be empty.",
  //   }),
  //   amount: Joi.number().messages({
  //     "number.base": "Amount must be a number.",
  //   }),
  //   opening_planning_meeting_agenda: Joi.number().messages({
  //     "number.base": "Opening Planning Meeting Agenda must be a number.",
  //   }),
  //   closing_planning_meeting_agenda: Joi.number().messages({
  //     "number.base": "Closing Planning Meeting Agenda must be a number.",
  //   }),
}).options({ allowUnknown: true });

export const auditExecutionCreateUpdateValidationSchema = Joi.object({
  scheduled_audit: Joi.number().required().messages({
    "any.required": "Scheduled Audit is required.",
    "number.base": "Scheduled Audit must be a number.",
  }),
  // audit_execution_id: Joi.string().messages({
  //     'string.empty': 'Actual Execution must not be empty.',
  // }),
  // actual_audit_start_date_time: Joi.date().iso().required().messages({
  //     'any.required': 'Actual Audit Start Date is required.',
  //     'string.empty': 'Actual Audit Start Date must not be empty.',
  //     'date.format': 'Actual Audit Start Date must be in ISO format.',
  // }),
  // actual_audit_end_date_time: Joi.date().iso().required().messages({
  //     'any.required': 'Actual Audit End Date is required.',
  //     'string.empty': 'Actual Audit End Date must not be empty.',
  //     'date.format': 'Actual Audit End Date must be in ISO format.',
  // }),
  // audit_protocol: Joi.number().required().messages({
  //     'any.required': 'Audit Protocol Audit is required.',
  //     'number.base': 'Audit Protocol Audit must be a number.',
  // }),
}).options({ allowUnknown: true });

/**Validation While create or update Permit License */
export const permitLicenseComplianceCreateUpdateValidationSchema = Joi.object({
  name: Joi.required().messages({
    "any.required": "Name is required.",
  }),
  permit_holder: Joi.required().messages({
    "any.required": "Permit Holder is required",
  }),
  permit_license_number: Joi.required().messages({
    "any.required": "Permit license number is required",
  }),
  permit_license_category: Joi.required().messages({
    "any.required": "Permit category is required",
  }),
  issuing_authority: Joi.required().messages({
    "any.required": "Issuing authority is required",
  }),
  issue_date: Joi.date().required().messages({
    "any.required": "Issue date is required",
    "date.format": "Issue date must be in the proper format",
  }),
  effective_date: Joi.date().required().messages({
    "any.required": "Effective from is required",
    "date.format": "Effective from date must be in the proper format",
  }),
}).options({ allowUnknown: true });

export const alertTypeCreateUpdateValidationSchema = Joi.object({
  name: Joi.required().messages({
    "any.required": "Level is required.",
    "string.empty": "Level must not be empty.",
  }),
}).options({ allowUnknown: true });

export const legislationValidationSchema = Joi.object({
  // document_title: Joi.required().messages({
  //   "any.required": "Document title is required",
  // }),
}).options({ allowUnknown: true });

export const createUpdateTeamsValidationSchema = Joi.object({
  name: Joi.string().required().messages({
    "any.required": "Name is required",
    "string.empty": "Name must not be empty",
  }),
  team_leader: Joi.number().integer().required().messages({
    "number.base": "Team leader ID must be a number.",
    "number.integer": "Team leader ID must be an integer.",
    "any.required": "Team leader ID is required.",
  }),
  // team_members: Joi.array().items(Joi.number().integer()).required().messages({
  //   "array.base": "Team members must be an array.",
  //   "array.empty": "Team members must not be empty.",
  //   "any.required": "Team members are required.",
  //   "number.base": "Team member ID must be a number.",
  //   "number.integer": "Team member ID must be an integer.",
  // }),
}).options({ allowUnknown: true });

/**Validation While create or update Incident */

const customMessages = {
  "string.base": "{{#label}} must be a string.",
  "string.max": "{{#label}} should not exceed {#limit} characters.",
  "array.base": "{{#label}} must be an array.",
  "array.includes": "{{#label}} must contain only valid items.",
  "any.required": "{{#label}} is required.",
  "date.base": "{{#label}} must be a valid date.",
  "date.format": "{{#label}} must be in ISO format.",
  "number.base": "{{#label}} must be a positive integer.",
  "number.positive": "{{#label}} must be a positive integer.",
  "any.only": "{{#label}} must be one of {{#valids}}.",
  "boolean.base": "{{#label}} must be true or false.",
  "string.pattern.base": "{{#label}} must be in the correct format.",
};

export const incidentCreateUpdateValidationSchema = Joi.object({
  incident_category: Joi.array()
    .items(Joi.number().integer().positive().label("Incident Category"))
    .required(),

  incident_title: Joi.string().max(255).required().label("Incident Title"),

  incident_report_id: Joi.string().max(250).label("Incident Report ID"),

  incident_reporting_date: Joi.date()
    .iso()
    .required()
    .label("Incident Reporting Date"),

  incident_actual_date: Joi.date()
    .iso()
    .required()
    .label("Incident Actual Date"),

  incident_actual_time: Joi.string()
    // .pattern(/^([01]\d|2[0-3]):([0-5]\d):([0-5]\d)$/)
    .required()
    .label("Incident Actual Time"),

  initial_incident_severity: Joi.number()
    .integer()
    .positive()
    .required()
    .label("Initial Incident Severity"),

  incident_location: Joi.array()
    .items(Joi.number().integer().positive().label("Incident Location"))
    .required()
    .label("Incident Location"),

  // specify: Joi.string()
  //   .max(500)
  //   .optional()
  //   .allow(null)
  //   .label("Specify Location Details"),

  // description: Joi.string()
  //   .optional()
  //   .allow(null)
  //   .optional()
  //   .label("Description"),
  save_type: Joi.string().valid("draft").optional().label("Save Type"),

  current_impact: Joi.string().optional().allow(null).label("Current Impact"),

  potential_impact: Joi.string()
    .optional()
    .allow(null)
    .label("Potential Impact"),

  person_type: Joi.string()
    .valid("Internal", "External", "Both")
    .optional()
    .label("Person Type"),
  was_the_person_licensed: Joi.boolean()
    .optional()
    .label("Was the Person Licensed"),

  permit_license: Joi.number()
    .integer()
    .positive()
    .optional()
    .label("Permit License"),

  incident_reporting_by: Joi.number()
    .integer()
    .positive()
    .required()
    .label("Incident Reporting By"),

  // notification: Joi.array()
  //   .items(Joi.number().integer().positive())
  //   .optional()
  //   .label("Notification IDs"),
  department: Joi.number().integer().positive().optional().label("Department"),
})
  .options({ allowUnknown: true })
  .messages(customMessages);

export const OperationalRiskIdentificationUpdateValidationSchema = Joi.object({
  risk_register_id: Joi.number().required().messages({
    "any.required": "Risk register is required",
    "number.base": "Risk register must be a number.",
  }),
  risk_name: Joi.string().required().messages({
    "any.required": "Risk name is required",
    "string.empty": "Risk name must not be empty.",
  }),
  risk_owner: Joi.required().messages({
    "any.required": "Risk owner is required.",
    "string.empty": "Risk owner must not be empty.",
  }),
  work_area: Joi.string().required().messages({
    "any.required": "Work area is required.",
    "string.empty": "Work area must not be empty.",
  }),
  main_process: Joi.string().required().messages({
    "any.required": "Main process is required.",
    "string.empty": "Main process must not be empty.",
  }),
  activity_service: Joi.string().required().messages({
    "any.required": "Activity service is required.",
    "string.empty": "Activity service must not be empty.",
  }),
  hazard_name: Joi.string().required().messages({
    "any.required": "Hazard Name is required.",
    "string.empty": "Hazard name must not be empty.",
  }),
  category_description: Joi.required().messages({
    "any.required": "Category description is required.",
  }),
  hazard_description: Joi.string().required().messages({
    "any.required": "Hazard description is required.",
    "string.empty": "Hazard description must not be empty.",
  }),
  risk_description: Joi.string().required().messages({
    "any.required": "Risk description is required.",
    "string.empty": "Risk description must not be empty.",
  }),
  impact_description: Joi.string().required().messages({
    "any.required": "Impact description is required.",
    "string.empty": "Impact description must not be empty.",
  }),
  frequency: Joi.number().integer().required().messages({
    "any.required": "Inherent frequency is required.",
    "number.base": "Inherent frequency must be a number.",
    "number.integer": "Inherent frequency must be an integer.",
  }),
  probability: Joi.number().integer().required().messages({
    "any.required": "Inherent probability is required.",
    "number.base": "Inherent probability must be a number.",
    "number.integer": "Inherent probability must be an integer.",
  }),
  consequence: Joi.number().integer().required().messages({
    "any.required": "Inherent consequence is required.",
    "number.base": "Inherent consequence must be a number.",
    "number.integer": "Inherent consequence must be an integer.",
  }),
  control_name: Joi.string().required().messages({
    "any.required": "Control name is required.",
    "string.empty": "Control name must not be empty.",
  }),
  control_description: Joi.string().required().messages({
    "any.required": "Control description is required.",
    "string.empty": "Control description must not be empty.",
  }),
}).options({ allowUnknown: true });

export const sidebarSchema = Joi.object({
  id: Joi.number().integer().positive().optional().label("Sidebar ID"),
  title: Joi.string().max(500).required().label("Title"),
  icon: Joi.string().max(500).required().label("Icon"),
  path: Joi.string().max(500).required().label("Path"),
  type: Joi.string()
    .valid("Module", "Tab", "SubTab")
    .required()
    .default("Module")
    .label("Type"),
  deleted: Joi.number()
    .integer()
    .valid(0, 1)
    .required()
    .default(0)
    .label("Deleted Status"),
  parent_id: Joi.number()
    .integer()
    .positive()
    .required()
    .default(0)
    .label("Parent ID"),
  sequence: Joi.number().integer().positive().required().label("Sequence"),
}).messages({
  "any.required": '"{#label}" is required',
  "string.base": '"{#label}" must be a string',
  "string.max": '"{#label}" must not exceed {#limit} characters',
  "number.base": '"{#label}" must be a valid number',
  "number.integer": '"{#label}" must be an integer',
  "number.positive": '"{#label}" must be a positive number',
  "any.only": '"{#label}" must be one of [{#valids}]',
});

export const stakeholderEngagementPlanValidationSchema = Joi.object({
  id: Joi.number().integer().positive().optional().label("id"),
  classification_type: Joi.string()
    .max(255)
    .required()
    .label("Classification Type"),
  priority_level: Joi.string().max(255).required().label("Priority Level"),
  stakeholder_category: Joi.number()
    .integer()
    .required()
    .label("Stakeholder Category"),
  stakeholder_name: Joi.string().max(255).required().label("Stakeholder Name"),
  recommended_engagement_level: Joi.string()
    .max(255)
    .required()
    .label("Recommended Engagement Level"),
  engagement_plan_name: Joi.string()
    .max(255)
    .required()
    .label("Engagement Plan Name"),
  engagement_plan_objectives: Joi.string()
    .max(255)
    .required()
    .label("Engagement Plan Objectives"),
  engagement_frequency: Joi.string()
    .max(255)
    .required()
    .label("Engagement Frequency"),
  engagement_start_date: Joi.date().required().label("Engagement Start Date"),
  no_of_cycles: Joi.string().max(255).required().label("Number of Cycles"),
  engagement_methods: Joi.string()
    .max(255)
    .required()
    .label("Engagement Methods"),
  engagement_level: Joi.number().integer().required().label("Engagement Level"),
  identification_id: Joi.number()
    .integer()
    .required()
    .label("Identification ID"),
  responsible_person: Joi.number()
    .integer()
    .required()
    .label("Responsible Person"),
  human_resource_requirements: Joi.array()
    .items(
      Joi.object({
        role: Joi.number().integer().required().label("Role ID"),
        no_of_peoples: Joi.number()
          .integer()
          .required()
          .label("Number of People"),
        role_name: Joi.string().max(255).required().label("Role Name"),
      })
    )
    .optional()
    .label("Human Resource Requirements"),
  technological_resources: Joi.array()
    .items(
      Joi.object({
        resources: Joi.string()
          .max(255)
          .required()
          .label("Resource Description"),
      })
    )
    .optional()
    .label("Technological Resources"),
  type_of_resources: Joi.string()
    .max(255)
    .optional()
    .label("Type of Resources"),
  amount: Joi.number().integer().optional().label("Amount"),
  currency: Joi.number().integer().optional().label("Currency"),
  department: Joi.number().integer().optional().label("Department"),
  organization: Joi.number().integer().optional().label("Organization"),
}).messages({
  "any.required": '"{#label}" is required',
  "string.base": '"{#label}" must be a string',
  "string.max": '"{#label}" must not exceed {#limit} characters',
  "number.base": '"{#label}" must be a valid number',
  "number.integer": '"{#label}" must be an integer',
  "date.base": '"{#label}" must be a valid date',
});

export const meetingNotesStatusChangeSchema = Joi.object({
  action_id: Joi.string().required(),
  meeting_id: Joi.string().required(),
  meeting_action_progress: Joi.string().trim().optional(),
  status: Joi.string().required(),
});
